/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 *
 * Portions Copyright Apache Software Foundation.
 */
package javax.servlet.jsp;

/**
 * Exception to be used by a Tag Handler to indicate some unrecoverable
 * error.
 * This error is to be caught by the top level of the JSP page and will result
 * in an error page.
 */

public class JspTagException extends JspException {
    /**
     * Constructs a new JspTagException with the specified message.
     * The message can be written to the server log and/or displayed
     * for the user.
     * 
     * @param msg a <code>String</code> specifying the text of 
     *     the exception message
     */
    public JspTagException(String msg) {
	super( msg );
    }

    /**
     * Constructs a new JspTagException with no message.
     */
    public JspTagException() {
	super();
    }

    /**
     * Constructs a new JspTagException when the JSP Tag
     * needs to throw an exception and include a message 
     * about the "root cause" exception that interfered with its 
     * normal operation, including a description message.
     *
     *
     * @param message 		a <code>String</code> containing 
     *				the text of the exception message
     *
     * @param rootCause		the <code>Throwable</code> exception 
     *				that interfered with the JSP Tag's
     *				normal operation, making this JSP Tag
     *				exception necessary
     *
     * @since JSP 2.0
     */
    public JspTagException(String message, Throwable rootCause) {
	super( message, rootCause );
    }


    /**
     * Constructs a new JSP Tag exception when the JSP Tag
     * needs to throw an exception and include a message
     * about the "root cause" exception that interfered with its
     * normal operation.  The exception's message is based on the localized
     * message of the underlying exception.
     *
     * <p>This method calls the <code>getLocalizedMessage</code> method
     * on the <code>Throwable</code> exception to get a localized exception
     * message. When subclassing <code>JspTagException</code>, 
     * this method can be overridden to create an exception message 
     * designed for a specific locale.
     *
     * @param rootCause 	the <code>Throwable</code> exception
     * 				that interfered with the JSP Tag's
     *				normal operation, making the JSP Tag 
     *                          exception necessary
     *
     * @since JSP 2.0
     */

    public JspTagException(Throwable rootCause) {
	super( rootCause );
    }

}
