/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.converter;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import ma.glasnost.orika.Converter;
import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.StateReporter;
import ma.glasnost.orika.converter.BidirectionalConverter;
import ma.glasnost.orika.converter.ConverterFactory;
import ma.glasnost.orika.impl.util.ClassUtil;
import ma.glasnost.orika.metadata.ConverterKey;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;
import ma.glasnost.orika.util.HashMapUtility;

public class DefaultConverterFactory
implements ConverterFactory,
StateReporter.Reportable {
    private static final Integer CACHE_SIZE = 2000;
    private final Map<ConverterKey, Converter<Object, Object>> converterCache;
    private Collection<Converter<Object, Object>> converters;
    private final Map<String, Converter<Object, Object>> convertersMap;
    private MapperFacade mapperFacade;

    public DefaultConverterFactory(Map<ConverterKey, Converter<Object, Object>> converterCache, Set<Converter<Object, Object>> converters) {
        this.converterCache = converterCache;
        this.converters = new CopyOnWriteArrayList<Converter<Object, Object>>();
        this.convertersMap = new ConcurrentHashMap<String, Converter<Object, Object>>();
    }

    public DefaultConverterFactory() {
        this((Map<ConverterKey, Converter<Object, Object>>)HashMapUtility.getConcurrentLinkedHashMap(CACHE_SIZE), (Set<Converter<Object, Object>>)new LinkedHashSet<Converter<Object, Object>>());
    }

    @Override
    public synchronized void setMapperFacade(MapperFacade mapperFacade) {
        this.mapperFacade = mapperFacade;
        LinkedHashSet<Converter<Object, Object>> orderedConverters = new LinkedHashSet<Converter<Object, Object>>();
        for (Converter<Object, Object> converter : this.converters) {
            converter.setMapperFacade(mapperFacade);
            orderedConverters.add(converter);
        }
        this.converters = orderedConverters;
        for (Converter<Object, Object> converter : this.convertersMap.values()) {
            converter.setMapperFacade(mapperFacade);
        }
    }

    @Override
    public boolean canConvert(Type<?> sourceType, Type<?> destinationType) {
        return this.getConverter(sourceType, destinationType) != null;
    }

    @Override
    public boolean hasConverter(String converterId) {
        return this.convertersMap.containsKey(converterId);
    }

    @Override
    public synchronized Converter<Object, Object> getConverter(Type<?> sourceClass, Type<?> destinationClass) {
        Converter<Object, Object> converter = this._converter(sourceClass, destinationClass);
        if (converter != null) {
            return converter;
        }
        if (sourceClass.isPrimitive()) {
            sourceClass = TypeFactory.valueOf(ClassUtil.getWrapperType(sourceClass.getRawType()));
            converter = this._converter(sourceClass, destinationClass);
        }
        if (converter != null) {
            return converter;
        }
        if (destinationClass.isPrimitive()) {
            destinationClass = TypeFactory.valueOf(ClassUtil.getWrapperType(destinationClass.getRawType()));
            converter = this._converter(sourceClass, destinationClass);
        }
        if (converter != null) {
            return converter;
        }
        return null;
    }

    private Converter<Object, Object> _converter(Type<?> sourceClass, Type<?> destinationClass) {
        ConverterKey key = new ConverterKey(sourceClass, destinationClass);
        if (this.converterCache.containsKey(key)) {
            return this.converterCache.get(key);
        }
        for (Converter<Object, Object> converter : this.converters) {
            if (!converter.canConvert(sourceClass, destinationClass)) continue;
            this.converterCache.put(key, converter);
            return converter;
        }
        return null;
    }

    @Override
    public Converter<Object, Object> getConverter(String converterId) {
        return this.convertersMap.get(converterId);
    }

    @Override
    public <S, D> void registerConverter(Converter<S, D> converter) {
        if (this.mapperFacade != null) {
            throw new IllegalStateException("Cannot register converters after MapperFacade has been initialized");
        }
        this.converters.add(converter);
        if (converter instanceof BidirectionalConverter && !converter.getAType().equals(converter.getBType())) {
            this.converters.add(((BidirectionalConverter)converter).reverse());
        }
    }

    @Override
    public <S, D> void registerConverter(String converterId, Converter<S, D> converter) {
        if (this.mapperFacade != null) {
            throw new IllegalStateException("Cannot register converters after MapperFacade has been initialized");
        }
        this.convertersMap.put(converterId, converter);
    }

    @Override
    public void reportCurrentState(StringBuilder out) {
        out.append("\n-------------------------------------------------------------");
        out.append("\nRegistered converters: ").append(this.converters.size()).append(" (approximate size: ").append(StateReporter.humanReadableSizeInMemory(this.converters)).append(")");
        int index = 0;
        for (Converter<Object, Object> converter : this.converters) {
            out.append("\n  [").append(index++).append("]: ").append(converter);
        }
        out.append("\n-------------------------------------------------------------");
        out.append("\nConverter cache: ").append(this.converterCache.size()).append(" (approximate size: ").append(StateReporter.humanReadableSizeInMemory(this.converterCache)).append(")");
        for (Map.Entry entry : this.converterCache.entrySet()) {
            Type srcType = TypeFactory.valueOf(((ConverterKey)entry.getKey()).getSourceClass());
            Type dstType = TypeFactory.valueOf(((ConverterKey)entry.getKey()).getDestinationClass());
            String srcName = TypeFactory.nameOf(srcType, dstType);
            String dstName = TypeFactory.nameOf(dstType, srcType);
            out.append("\n  [").append(srcName).append(" -> ").append(dstName).append("] : ").append(entry.getValue());
        }
    }
}

