/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator.specification;

import ma.glasnost.orika.Converter;
import ma.glasnost.orika.impl.generator.MultiOccurrenceVariableRef;
import ma.glasnost.orika.impl.generator.SourceCodeContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.generator.specification.AbstractSpecification;
import ma.glasnost.orika.metadata.FieldMap;
import ma.glasnost.orika.metadata.Type;

public class ConvertArrayOrCollectionToArray
extends AbstractSpecification {
    @Override
    public boolean appliesTo(FieldMap fieldMap) {
        if (fieldMap.getConverterId() != null) {
            Converter<Object, Object> converter = this.mapperFactory.getConverterFactory().getConverter(fieldMap.getConverterId());
            if (fieldMap.getDestination().isArray() && (fieldMap.getSource().isArray() || fieldMap.getSource().isCollection())) {
                Type<Object> sourceElementType = fieldMap.getSource().isArray() ? fieldMap.getAType().getComponentType() : fieldMap.getAType().getNestedType(0);
                Type<?> destElementType = fieldMap.getBType().getComponentType();
                if (converter.getAType().isAssignableFrom(sourceElementType) && converter.getBType().isAssignableFrom(destElementType) && (!converter.getAType().isAssignableFrom(fieldMap.getAType()) || !converter.getBType().isAssignableFrom(fieldMap.getBType()))) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String generateMappingCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        if (destination.elementType().isPrimitive()) {
            if (code.isDebugEnabled()) {
                code.debugField(fieldMap, "converting to primitive array using " + source.getConverter());
            }
        } else if (code.isDebugEnabled()) {
            code.debugField(fieldMap, "converting to array using " + source.getConverter());
        }
        String assureInstanceExists = String.format("if((%s)) { \n %s; \n}", destination.isNull(), destination.assign("new %s[%s]", destination.elementTypeName(), source.size()));
        StringBuilder convertArray = new StringBuilder();
        MultiOccurrenceVariableRef moSource = MultiOccurrenceVariableRef.from(source);
        MultiOccurrenceVariableRef moDest = MultiOccurrenceVariableRef.from(destination);
        SourceCodeContext.append(convertArray, moSource.declareIterator(), moDest.declareIterator(), "while(" + moSource.iteratorHasNext() + ") {", String.format("%s = (%s) %s.convert((%s)%s, %s, mappingContext)", moDest.nextElement(), moDest.elementTypeName(), code.usedConverter(source.getConverter()), moSource.elementTypeName(), moSource.nextElement(), code.usedType(destination)), "}");
        String mapNull = ConvertArrayOrCollectionToArray.shouldMapNulls(fieldMap, code) ? String.format(" else { %s; }", destination.assignIfPossible("null", new Object[0])) : "";
        return String.format(" %s { %s; %s; } %s", source.ifNotNull(), assureInstanceExists, convertArray, mapNull);
    }
}

