/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.checksum.validation;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import me.desair.tus.server.HttpMethod;
import me.desair.tus.server.RequestValidator;
import me.desair.tus.server.checksum.ChecksumAlgorithm;
import me.desair.tus.server.exception.ChecksumAlgorithmNotSupportedException;
import me.desair.tus.server.exception.TusException;
import me.desair.tus.server.upload.UploadStorageService;
import org.apache.commons.lang3.StringUtils;

public class ChecksumAlgorithmValidator
implements RequestValidator {
    @Override
    public void validate(HttpMethod method, HttpServletRequest request, UploadStorageService uploadStorageService, String ownerKey) throws TusException, IOException {
        String uploadChecksum = request.getHeader("Upload-Checksum");
        if (StringUtils.isNotBlank((CharSequence)uploadChecksum) && ChecksumAlgorithm.forUploadChecksumHeader(uploadChecksum) == null) {
            throw new ChecksumAlgorithmNotSupportedException("The Upload-Checksum header value " + uploadChecksum + " is not supported");
        }
    }

    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.PATCH.equals((Object)method);
    }
}

