/*
 * Decompiled with CFR 0.152.
 */
package me.desair.tus.server.upload;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Objects;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadId
implements Serializable {
    private static final String UPLOAD_ID_CHARSET = "UTF-8";
    private static final Logger log = LoggerFactory.getLogger(UploadId.class);
    private String urlSafeValue;
    private Serializable originalObject;

    public UploadId(Serializable inputObject) {
        String inputValue = inputObject == null ? null : inputObject.toString();
        Validate.notBlank((CharSequence)inputValue, (String)"The upload ID value cannot be blank", (Object[])new Object[0]);
        this.originalObject = inputObject;
        URLCodec codec = new URLCodec();
        try {
            this.urlSafeValue = inputValue != null && inputValue.equals(codec.decode(inputValue, UPLOAD_ID_CHARSET)) ? codec.encode(inputValue, UPLOAD_ID_CHARSET) : inputValue;
        }
        catch (UnsupportedEncodingException | DecoderException e) {
            log.warn("Unable to URL encode upload ID value", e);
            this.urlSafeValue = inputValue;
        }
    }

    public Serializable getOriginalObject() {
        return this.originalObject;
    }

    public String toString() {
        return this.urlSafeValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UploadId)) {
            return false;
        }
        UploadId uploadId = (UploadId)o;
        return Objects.equals(this.urlSafeValue, uploadId.urlSafeValue);
    }

    public int hashCode() {
        return Objects.hash(this.urlSafeValue);
    }
}

