package com.mm.c.cloud;

import java.io.Serializable;
import java.util.Date;

public class CloudAccount implements Serializable {
    protected long id;
    protected long accountId;
    protected String site;
    protected String account;
    // 网盘别名
    protected String alias;
    //当前状态
    protected EnumCloudAcctStatus status;
    //前一次状态,用于判断当前状态和前一次状态的关系，例如判断delete pending是否需要请求服务器同步数据
    protected EnumCloudAcctStatus prevStatus;
    protected EnumPasswordType passwordType;
    //保存加密后的hashedPassword
    protected String cryptoPassword;
    //记录状态的信息，比如异常信息等
    protected String statusMessage;
    //Meta服务器的同步状态
    protected EnumLinkSyncStatus linkSyncStatus;
    //同步到meta服务器的日期
    protected Date LinkSyncDate;
    //与meta服务器检查的最后日期
    protected Date linkSyncCheckDate;
    //内容数据签名checksum
    protected String linkChecksum;
    //网盘文件夹的checksum，用于识别网盘的文件变化标识,比如:文件夹的大小，或者指定文件的时间戳
    protected String cloudChecksum;
    //网盘中扫描获得的视频个数. 这里是视频文件的数量，比如电视剧的一集算一个
    protected int videoCount;
    //上次刷新有效视频数量
    protected int lastEffectiveVideoCount;
    //当前有效视频数量
    protected int currentEffectiveVideoCount;
    //创建日期
    protected Date createDate;
    //最后更新日期
    protected Date updateDate;
    //最后更新网盘内容的日期
    protected Date refreshDate;
    //是否开机刷新
    protected boolean refreshOnBoot;
    //刷新间隔 单位为分钟
    protected long refreshInterval;
    //最后远程刷新时间
    protected long remoteRefreshTime;
    //网盘刷新状态信息Normal, Refreshing, Expired, Verify failed
    protected String refreshStatusInfo;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getAccountId() {
        return accountId;
    }

    public void setAccountId(long accountId) {
        this.accountId = accountId;
    }

    public String getSite() {
        return site;
    }

    public void setSite(String site) {
        this.site = site;
    }

    public String getAccount() {
        return account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public EnumCloudAcctStatus getStatus() {
        return status;
    }

    public void setStatus(EnumCloudAcctStatus status) {
        this.status = status;
    }

    public EnumCloudAcctStatus getPrevStatus() {
        return prevStatus;
    }

    public void setPrevStatus(EnumCloudAcctStatus prevStatus) {
        this.prevStatus = prevStatus;
    }

    public EnumPasswordType getPasswordType() {
        return passwordType;
    }

    public void setPasswordType(EnumPasswordType passwordType) {
        this.passwordType = passwordType;
    }

    public String getCryptoPassword() {
        return cryptoPassword;
    }

    public void setCryptoPassword(String cryptoPassword) {
        this.cryptoPassword = cryptoPassword;
    }

    public String getStatusMessage() {
        return statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public EnumLinkSyncStatus getLinkSyncStatus() {
        return linkSyncStatus;
    }

    public void setLinkSyncStatus(EnumLinkSyncStatus linkSyncStatus) {
        this.linkSyncStatus = linkSyncStatus;
    }

    public Date getLinkSyncDate() {
        return LinkSyncDate;
    }

    public void setLinkSyncDate(Date linkSyncDate) {
        LinkSyncDate = linkSyncDate;
    }

    public Date getLinkSyncCheckDate() {
        return linkSyncCheckDate;
    }

    public void setLinkSyncCheckDate(Date linkSyncCheckDate) {
        this.linkSyncCheckDate = linkSyncCheckDate;
    }

    public String getLinkChecksum() {
        return linkChecksum;
    }

    public void setLinkChecksum(String linkChecksum) {
        this.linkChecksum = linkChecksum;
    }

    public String getCloudChecksum() {
        return cloudChecksum;
    }

    public void setCloudChecksum(String cloudChecksum) {
        this.cloudChecksum = cloudChecksum;
    }

    public int getVideoCount() {
        return videoCount;
    }

    public void setVideoCount(int videoCount) {
        this.videoCount = videoCount;
    }

    public int getLastEffectiveVideoCount() {
        return lastEffectiveVideoCount;
    }

    public void setLastEffectiveVideoCount(int lastEffectiveVideoCount) {
        this.lastEffectiveVideoCount = lastEffectiveVideoCount;
    }

    public int getCurrentEffectiveVideoCount() {
        return currentEffectiveVideoCount;
    }

    public void setCurrentEffectiveVideoCount(int currentEffectiveVideoCount) {
        this.currentEffectiveVideoCount = currentEffectiveVideoCount;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public Date getRefreshDate() {
        return refreshDate;
    }

    public void setRefreshDate(Date refreshDate) {
        this.refreshDate = refreshDate;
    }

    public boolean isRefreshOnBoot() {
        return refreshOnBoot;
    }

    public void setRefreshOnBoot(boolean refreshOnBoot) {
        this.refreshOnBoot = refreshOnBoot;
    }

    public long getRefreshInterval() {
        return refreshInterval;
    }

    public void setRefreshInterval(long refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public long getRemoteRefreshTime() {
        return remoteRefreshTime;
    }

    public void setRemoteRefreshTime(long remoteRefreshTime) {
        this.remoteRefreshTime = remoteRefreshTime;
    }

    public String getRefreshStatusInfo() {
        return refreshStatusInfo;
    }

    public void setRefreshStatusInfo(String refreshStatusInfo) {
        this.refreshStatusInfo = refreshStatusInfo;
    }
}
