package com.mm.c.cloud;

import android.content.Context;
import android.text.TextUtils;

import com.mm.c.cloud.help.CloudSite;
import com.mm.c.cloud.lib.logger.TimberUtils;
import com.mm.c.cloud.manager.GlobalCloudManager;
import com.valor.mfc.vms.api.model.cloud.CloudAcctDo;
import com.valor.mfc.vms.api.model.cloud.ECloudAcctStatus;
import com.valor.mfc.vms.api.model.cloud.ELoginType;

import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CloudUtil {
    private static final String CRP_ZIP_PASSWD = "3721";
    private static final String RES_PKG_FILE_FIELD_SEPARATOR = ":";
    private static final String RES_PKG_FILE_NAME = "name";
    private static final String RES_PKG_FILE_DESC = "desc";
    private static final String RES_PKG_FILE_CREATE_TIME = "createTime";
    private static final String RES_PKG_FILE_AUTHOR = "author";
    private static final String RES_PKG_FILE_VERSION = "version";
    private static final String RES_PKG_FILE_IS_PROTECTED = "isProtected";

    public static CloudResourcePackage getCloudResourcePackage(String filePath, String destDir) {
        try {
            ZipFile zipFile = new ZipFile(filePath);
            if (!zipFile.isValidZipFile()) {
                return null;
            }
            if (zipFile.isEncrypted()) {
                zipFile.setPassword(CRP_ZIP_PASSWD);
            }
            List<FileHeader> headerList = zipFile.getFileHeaders();
            //Resource zip包只允许存在一个文件
            if (headerList.size() != 1) {
                return null;
            }
            zipFile.extractAll(destDir); //解压
            File dataFile = new File(destDir + File.separator + headerList.get(0).getFileName());
            if (!dataFile.exists()) { //解压是否成功
                TimberUtils.e("data file does not exists");
                return null;
            }
            return readFile2CloudResourcePackage(filePath, dataFile.getAbsolutePath()); //读取解压出的resource文件
        } catch (ZipException e) {
            TimberUtils.e(e, "encounter error when unzip the cloud resource package");
            return null;
        }
    }

    public static CloudResourcePackage readFile2CloudResourcePackage(String filePath,String fn) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(fn));
            CloudResourcePackage resPkgFile = new CloudResourcePackage();
            String line;
            while ((line = br.readLine()) != null) {
                int pos = line.indexOf(RES_PKG_FILE_FIELD_SEPARATOR);
                String title = line.substring(0, pos);
                String value = line.substring(pos + 1);

                switch (title) {
                    case RES_PKG_FILE_NAME:
                        resPkgFile.setName(value);
                        break;
                    case RES_PKG_FILE_DESC:
                        resPkgFile.setDescription(value);
                        break;
                    case RES_PKG_FILE_CREATE_TIME:
                        resPkgFile.setCreateTime(value);
                        break;
                    case RES_PKG_FILE_AUTHOR:
                        resPkgFile.setAuthor(value);
                        break;
                    case RES_PKG_FILE_VERSION:
                        resPkgFile.setVersion(value);
                        break;
                    case RES_PKG_FILE_IS_PROTECTED:
                        resPkgFile.setProtected(!"0".equals(value)); // 0 没有 1 有
                        break;
                    default:
                }
            }
            resPkgFile.setPackagePath(filePath);
            return resPkgFile;
        } catch (IOException ignored) {
            return null;
        } finally {
            if (br != null) try {
                br.close();
            } catch (IOException ignored) {
            }
        }
    }

    public static String convertImportResultStr(Context context, ECloudImportState state) {
        switch (state) {
            case IMPORT_SUCCESS:
                return context.getString(R.string.cloud_pack_imp_success);
            case IMPORT_FAILED:
                return context.getString(R.string.cloud_pack_imp_failed);
            case NOT_SUPPORTED_SITE:
                return context.getString(R.string.cloud_pack_imp_not_supported);
            case ALREADY_EXISTS:
                return context.getString(R.string.cloud_pack_imp_already_exists);
            default:
                return "";
        }
    }

    public static CloudAccount cloneAccount(CloudAccount item) {
        CloudAccount model = new CloudAccount();
        model.setId(item.getId());
        model.setSite(item.getSite());
        model.setAccount(item.getAccount());
        model.setStatusMessage(item.getStatusMessage());
        if (GlobalCloudManager.getInstance().getCallback().isHot()) {
            model.setStatus(item.getStatus());
        } else {
            model.setRefreshStatusInfo(item.getRefreshStatusInfo());
        }
        model.setPasswordType(item.getPasswordType());
        model.setCryptoPassword(item.getCryptoPassword());
        model.setAlias(item.getAlias());
        model.setRemoteRefreshTime(item.getRemoteRefreshTime());
        model.setCloudChecksum(item.getCloudChecksum());
        model.setVideoCount(item.getVideoCount());
        model.setRefreshOnBoot(item.isRefreshOnBoot());
        model.setRefreshInterval(item.getRefreshInterval()); // default
        model.setUpdateDate(item.getUpdateDate());
        model.setRefreshDate(item.getRefreshDate());
        return model;
    }

    //***************************************************************************************************//
    //
    //
    //下面是tvapp/src/main/java/com/valor/mfc/droid/tvapp/cloud/CloudUtil.java 里的函数也写到这里
    //
    //
    //***************************************************************************************************//
    public static CloudAccount convertCloudAcctDo2CloudAccount(CloudAcctDo metaAccount) {
        Date now = new Date();
        CloudAccount cloudAccount = new CloudAccount();
        cloudAccount.setId(metaAccount.getCid());
        cloudAccount.setSite(metaAccount.getSite());
        cloudAccount.setAccount(metaAccount.getAcct());
        cloudAccount.setStatusMessage(metaAccount.getStatusMsg());
        if (GlobalCloudManager.getInstance().getCallback().isHot()) {
            if (metaAccount.getRefreshStatus().equalsIgnoreCase(ECloudAcctStatus.EXPIRED.name())) {
                cloudAccount.setStatus(EnumCloudAcctStatus.EXPIRED);
            } else if (metaAccount.getRefreshStatus().equalsIgnoreCase(ECloudAcctStatus.REFRESH_SUCCESS.name()) || metaAccount.getRefreshStatus().equalsIgnoreCase(ECloudAcctStatus.LOGIN_SUCCESS.name())) {
                cloudAccount.setStatus(EnumCloudAcctStatus.NORMAL);
            } else if (metaAccount.getRefreshStatus().equalsIgnoreCase(ECloudAcctStatus.WAIT_FOR_REFRESH.name()) || metaAccount.getRefreshStatus().equalsIgnoreCase(ECloudAcctStatus.REFRESHING.name())) {
                cloudAccount.setStatus(EnumCloudAcctStatus.REFRESHING);
            } else {
                cloudAccount.setStatus(EnumCloudAcctStatus.CHECK_FAILED);
            }
        } else {
            //add by tony
            cloudAccount.setRefreshStatusInfo(metaAccount.getRefreshStatusInfo());
        }
        cloudAccount.setPasswordType(metaAccount.getLoginType().equals(ELoginType.ENCRYPTED.name()) ? EnumPasswordType.HASH : EnumPasswordType.ORIGINAL);
        cloudAccount.setCryptoPassword(metaAccount.getLoginKey());
        if (TextUtils.isEmpty(metaAccount.getAcctAlias())) {
            cloudAccount.setAlias(metaAccount.getSite() + "_" + metaAccount.getAcct().substring(0, metaAccount.getAcct().lastIndexOf("@")));
        } else {
            cloudAccount.setAlias(metaAccount.getAcctAlias());
        }
        cloudAccount.setRemoteRefreshTime(metaAccount.getRefreshTime());
        cloudAccount.setCloudChecksum(metaAccount.getChecksum());
        cloudAccount.setVideoCount(metaAccount.getFileCount());
        cloudAccount.setRefreshOnBoot(false);
        cloudAccount.setRefreshInterval(-1); // default
        cloudAccount.setUpdateDate(now);
        cloudAccount.setRefreshDate(now);
        return cloudAccount;
    }

    public static long getDelayedTimeMillis(int HOUR_OF_DAY) {
        int REFRESH_TIME_HOUR = HOUR_OF_DAY; // 刷新时间点。小时
        GregorianCalendar nowCalendar = new GregorianCalendar();
        GregorianCalendar nextCalendar = new GregorianCalendar();
        nextCalendar.set(GregorianCalendar.MINUTE, 0);
        nextCalendar.set(GregorianCalendar.SECOND, 0);
        if (nowCalendar.get(GregorianCalendar.YEAR) < 2010) {
            // ntp未同步成功，不处理
            return -1;
        }
        int currentHour = nextCalendar.get(GregorianCalendar.HOUR_OF_DAY);
        nextCalendar.add(GregorianCalendar.HOUR_OF_DAY, currentHour >= REFRESH_TIME_HOUR ? 24 + REFRESH_TIME_HOUR - currentHour : REFRESH_TIME_HOUR - currentHour);
        long delayMs = nextCalendar.getTimeInMillis() - nowCalendar.getTimeInMillis();
        return delayMs;
    }

    public static boolean isSupportedSite(String site) {
        if (site == null || (site != null && site.equals(""))) {
            return false;
        } else {
            CloudSite cloudSite = CloudSite.valueOf(site);
            if (cloudSite == null) {
                return false;
            } else {
                return isSupportedSite(cloudSite);
            }
        }
    }

    private static final Set<CloudSite> unsupportedSites = new HashSet<>();

    static {
        unsupportedSites.addAll(Arrays.asList(CloudSite.GOOGLE_DRIVE, CloudSite.DROPBOX, CloudSite.MEDIAFIRE, CloudSite.AMAZON_DRIVE, CloudSite.PCLOUD, CloudSite.HUBIC));
    }

    public static boolean isSupportedSite(CloudSite site) {
        return !unsupportedSites.contains(site);
    }
}
