package com.mm.c.cloud.api;

import com.mm.c.cloud.help.Utils;
import com.mm.c.cloud.lib.api.ns.model.INSInfo;
import com.mm.c.cloud.lib.api.ns.model.NSResponse;
import com.mm.c.cloud.lib.api.response.ResponseDataSingle;
import com.mm.c.cloud.help.UrlUtils;
import com.mm.c.cloud.lib.api.service.NSService;
import com.mm.c.cloud.lib.device.HardwareInfo;
import com.mm.c.cloud.lib.misc.utils.MiscUtils;
import com.mm.c.cloud.manager.GlobalCloudManager;
import com.mm.c.cloud.server.BaseServer;
import com.mm.c.cloud.server.HostProvider;
import com.mm.c.cloud.sign.SsoKey;

import org.apache.commons.lang3.StringUtils;

import rx.Observable;
import rx.functions.Func1;

public class NSServerApi extends BaseServer<NSService> {
    private static NSServerApi instance;

    private NSService service;
    private String deviceInfo;

    public NSServerApi() {
        super(NSService.class);
        service = getBasicApi();
    }

    public Observable<? extends INSInfo> getAddress(String checksum) throws Exception {
        String sessionKey = SsoKey.getSessionKey(getDid(), getUserKey());
        return service.getAddress(getDid(), getUid(), getUserKey(), sessionKey,
                getCountry(), getAppVer(), getLanguage(), getDeviceInfo(), checksum)
                .map((Func1<ResponseDataSingle<NSResponse>, INSInfo>) nsResponseResponseDataSingle -> {
                    if (nsResponseResponseDataSingle == null) {
                        return null;
                    }
                    return nsResponseResponseDataSingle.getResult();
                });
    }

    public static NSServerApi getInstance() {
        if (instance == null) {
            instance = new NSServerApi();
        }
        return instance;
    }

    private String getDid() {
        return HardwareInfo.getInstance().getUserMac();
    }

    private int getAppVer() {
        return GlobalCloudManager.getInstance().getCallback().getAppVersion();
    }

    private String getUid() {
        return String.valueOf(GlobalCloudManager.getInstance().getCallback().getUserId());
    }

    private String getUserKey() {
        return GlobalCloudManager.getInstance().getCallback().getUserKey();
    }

    /**
     * 获取国家
     */
    public String getCountry() {
        return GlobalCloudManager.getInstance().getCallback().getDetectedCountryCode();
    }

    /**
     * 获取语言
     */
    private String getLanguage() {
        return MiscUtils.getLocaleString();
    }

    /**
     * 获取设备信息
     */
    private String getDeviceInfo() {
        if (StringUtils.isEmpty(deviceInfo)) {
            deviceInfo = Utils.getDeviceInfo();
        }
        return deviceInfo;
    }

    @Override
    protected HostProvider getProvider() {
        HostProvider provider = new HostProvider("ns", UrlUtils.getNSHost());//BuildConfig.NS_HOST_KEY
        return provider;
    }
}
