package com.mm.c.cloud.cloud;

import android.text.TextUtils;
import android.util.Log;

import com.mm.c.cloud.CloudAccount;
import com.mm.c.cloud.interceptor.RequestParams;
import com.mm.c.cloud.lib.api.response.ResponseDataList;
import com.mm.c.cloud.lib.api.response.ResponseDataSingle;
import com.mm.c.cloud.help.UrlUtils;
import com.mm.c.cloud.lib.api.service.CloudRefreshServerApi;
import com.mm.c.cloud.lib.device.HardwareInfo;
import com.mm.c.cloud.lib.misc.utils.MiscUtils;
import com.mm.c.cloud.manager.GlobalCloudManager;
import com.mm.c.cloud.server.BaseServer;
import com.mm.c.cloud.server.HostProvider;
import com.mm.c.cloud.lib.eventbus.BusProvider;
import com.mm.c.cloud.lib.eventbus.event.PreferencesChangeEvent;
import com.mm.c.cloud.lib.eventbus.event.UserActivateEvent;
import com.mm.c.cloud.lib.logger.TimberUtils;
import com.mm.c.cloud.lib.metric.MetricData;
import com.mm.c.cloud.lib.metric.MetricManager;
import com.mm.c.cloud.lib.metric.model.MetricAction;
import com.mm.c.cloud.lib.metric.model.MetricType;
import com.mm.c.cloud.lib.misc.crypto.AESCodecAndroid;
import com.valor.mfc.vms.api.model.cloud.CloudAcctDo;
import com.valor.mfc.vms.api.model.cloud.ELoginType;
import com.valor.mfc.vms.api.model.common.response.ResponseStatus;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import retrofit.mime.TypedFile;
import rx.Observable;
import rx.functions.Action0;

public class CloudRefreshServer extends BaseServer<CloudRefreshServerApi> {
    private final static String TAG = CloudRefreshServer.class.getSimpleName();
    private static CloudRefreshServer sInstance;
    private HostProvider provider;

    private String language;
    private int appVer;
    private String region;

    private final String CLOUD_SYNC_HOST_KEY = "cs";

    public CloudRefreshServer() {
        super(CloudRefreshServerApi.class);
        appVer = GlobalCloudManager.getInstance().getCallback().getAppVersion();
        language = MiscUtils.getLocaleString();
        region = GlobalCloudManager.getInstance().getCallback().getRegion();
        BusProvider.getInstance().register(this);
    }

    public static CloudRefreshServer getInstance() {
        if (sInstance == null) {
            synchronized (CloudRefreshServer.class) {
                if (sInstance == null) {
                    sInstance = new CloudRefreshServer();
                }
            }
        }
        return sInstance;
    }

    private String getUid() {
        return String.valueOf(GlobalCloudManager.getInstance().getCallback().getUserId());
    }

    private String getLanguage() {
        if (TextUtils.isEmpty(language)) {
            language = MiscUtils.getLocaleString();
        }
        return language;
    }

    private String getRegion() {
        if (TextUtils.isEmpty(region)) {
            region = GlobalCloudManager.getInstance().getCallback().getRegion();
        }
        return region;
    }

    public Observable<ResponseDataList<CloudAcctDo>> rxQueryList(String site, boolean includeLogin) {
        Map<String, String> params = new HashMap<>();//RequestParams.getCommonParams();
        params.put("site", site);
        params.put("includeLogin", String.valueOf(includeLogin ? 1 : 0));
        return getSsoApiWithCookie().rxQueryList(params);
    }

    public Observable<ResponseDataList<CloudAcctDo>> rxQueryList() {
        String token = GlobalCloudManager.getInstance().getCallback().getToken();
        int accountType = GlobalCloudManager.getInstance().getCallback().getAccountType();
        long accountId = GlobalCloudManager.getInstance().getCallback().getAccountId();
        return getSsoApiWithCookie().rxQueryList(token, accountType, accountId, getUid(), "", 1, appVer, getLanguage(), getRegion());
    }

    //异步请求批量刷新网盘
    public Observable<ResponseStatus> rxRequestCloudRefresh(ArrayList<Long> mCids, String acct) {
        StringBuilder cids = new StringBuilder();
        for (int i = 0; i < mCids.size(); i++) {
            cids.append(String.valueOf(mCids.get(i))).append("_");
        }
        String token = GlobalCloudManager.getInstance().getCallback().getToken();
        int accountType = GlobalCloudManager.getInstance().getCallback().getAccountType();
        long accountId = GlobalCloudManager.getInstance().getCallback().getAccountId();
        Log.i(TAG, "cids string requested by the client to be refreshed = " + cids.toString());
        Log.i(TAG, "cids string size requested by the client = " + mCids.size());
        return getSsoApiWithCookie().rxRequestCloudRefresh(token, accountType, accountId, getUid(), cids.toString(), acct, appVer, getLanguage(), getRegion())
                .doOnCompleted(new Action0() {
                    @Override
                    public void call() {

                    }
                });
    }

    public Observable<ResponseStatus> rxCloudDelAll() {
        String token = GlobalCloudManager.getInstance().getCallback().getToken();
        int accountType = GlobalCloudManager.getInstance().getCallback().getAccountType();
        long accountId = GlobalCloudManager.getInstance().getCallback().getAccountId();
        String did = HardwareInfo.getInstance().getUserMac();
        return getSsoApiWithCookie().rxCloudDelAll(token, accountType, accountId, getUid(), appVer, did)
                .doOnCompleted(new Action0() {
                    @Override
                    public void call() {
                        // metric
                        MetricManager.getInstance().put(MetricAction.MFC_APP_CLOUD_ACTION,
                                new MetricData.Builder().put("actionType", MetricType.CLOUD_DEL_ALL.getDesc()).build());
                    }
                });
    }

    public Observable<ResponseDataSingle<CloudAcctDo>> rxCloudReg(String site, String acct, String alias, ELoginType loginType, String loginId, String loginKey) {
        String token = GlobalCloudManager.getInstance().getCallback().getToken();
        int accountType = GlobalCloudManager.getInstance().getCallback().getAccountType();
        long accountId = GlobalCloudManager.getInstance().getCallback().getAccountId();
        String uid = getUid();
        String encryptLoginKey = encryptLoginKey(loginKey);
        String lang = getLanguage();
        String region = getRegion();
        return getSsoApiWithCookie().rxCloudReg(token, accountType, accountId, uid, site, acct, alias, loginType, loginId, encryptLoginKey, appVer, lang, region);
    }

    public Observable<ResponseDataSingle<CloudAcctDo>> rxCloudRefresh(String site, long cid, String acct) {
        String token = GlobalCloudManager.getInstance().getCallback().getToken();
        int accountType = GlobalCloudManager.getInstance().getCallback().getAccountType();
        long accountId = GlobalCloudManager.getInstance().getCallback().getAccountId();
        return getSsoApiWithCookie().rxCloudRefresh(token, accountType, accountId, getUid(), site, cid, acct, appVer, getLanguage(), getRegion());
    }

    public Observable<ResponseDataList<CloudAcctDo>> rxQueryListWithAccount(String site, long cid, String account, boolean includeLogin) {
        Log.i(TAG, "========================queryCloudListWithAccount===================");
        String token = GlobalCloudManager.getInstance().getCallback().getToken();
        int accountType = GlobalCloudManager.getInstance().getCallback().getAccountType();
        long accountId = GlobalCloudManager.getInstance().getCallback().getAccountId();
        return getSsoApiWithCookie().rxQueryListWithAcct(token, accountType, accountId, getUid(), site, cid, account, includeLogin ? 1 : 0, appVer, getLanguage(), getRegion());
    }

    public Observable<ResponseStatus> rxCloudDel(String site, long cid, String acct) {
        String token = GlobalCloudManager.getInstance().getCallback().getToken();
        int accountType = GlobalCloudManager.getInstance().getCallback().getAccountType();
        long accountId = GlobalCloudManager.getInstance().getCallback().getAccountId();
        return getSsoApiWithCookie().rxCloudDel(token, accountType, accountId, getUid(), site, cid, acct, appVer, language, region)
                .doOnCompleted(new Action0() {
                    @Override
                    public void call() {
                        MetricManager.getInstance().put(MetricAction.MFC_APP_CLOUD_ACTION,
                                new MetricData.Builder().put("actionType", MetricType.CLOUD_DEL_ONE.getDesc()).build());
                    }
                });
    }

    public Observable<ResponseDataList<CloudAcctDo>> rxImportResPkg(String filePath, String actCode) {
        TypedFile file = new TypedFile("multipart/form-data", new File(filePath));
        String token = GlobalCloudManager.getInstance().getCallback().getToken();
        int accountType = GlobalCloudManager.getInstance().getCallback().getAccountType();
        long accountId = GlobalCloudManager.getInstance().getCallback().getAccountId();
        return getSsoApiWithCookie().rxImportResPkg(file, token, accountType, accountId, actCode, getUid(), appVer, getLanguage(), getRegion());
    }

    private String encryptLoginKey(String loginKey) {
        String encryptKey = "";
        try {
            encryptKey = AESCodecAndroid.encrypt(loginKey, GlobalCloudManager.getInstance().getCallback().getApiServerKey());
        } catch (Exception e) {
            TimberUtils.e(e, "encrypt loginKey error");
        }
        return encryptKey;
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onPreferenceEvent(PreferencesChangeEvent event) {
        provider.merge(UrlUtils.getCloudsyncHost());
    }

    @Subscribe(threadMode = ThreadMode.BACKGROUND)
    public void onUserActivated(UserActivateEvent event) {

    }

    @Override
    protected HostProvider getProvider() {
        provider = new HostProvider(CLOUD_SYNC_HOST_KEY, UrlUtils.getCloudsyncHost());
        return provider;
    }
}
