//package com.mm.c.cloud.dao;
//
//import com.mm.c.cloud.BuildConfig;
//import com.mm.c.cloud.CloudAccount;
//import com.mm.c.cloud.EnumCloudAcctStatus;
//import com.mm.c.cloud.lib.dao.Requery;
//import com.mm.c.cloud.lib.dao.model.CloudFolder;
//import com.mm.c.cloud.manager.GlobalCloudManager;
//import com.mm.c.cloud.lib.logger.TimberUtils;
//
//import java.util.ArrayList;
//import java.util.Date;
//import java.util.List;
//import java.util.Map;
//
//import io.requery.meta.QueryAttribute;
//import io.requery.query.Tuple;
//import timber.log.Timber;
//
//public class CloudDao {
//    private static CloudDao instance;
//
//    private CloudDao() {
//    }
//
//    public static CloudDao getInstance() {
//        if (instance == null) {
//            synchronized (CloudDao.class) {
//                if (instance == null)
//                    instance = new CloudDao();
//            }
//        }
//        return instance;
//    }
//
//    public List<String> getFolderChecksumsByAcctId(String acctId) {
//        List<Tuple> tuples = Requery.store().select(CloudFolder.CHANGE_CHECKSUM)
//                .where(CloudFolder.ACCT_ID.eq(acctId))
//                .orderBy(CloudFolder.CHANGE_CHECKSUM.asc())
//                .get().toList();
//        List<String> strings = new ArrayList<>(tuples.size());
//        for (Tuple tuple : tuples) {
//            strings.add(tuple.get(CloudFolder.CHANGE_CHECKSUM));
//        }
//        return strings;
//    }
//
//    public void saveAccount(CloudAccount cloudAccount) {
//        cloudAccount.setAccountId(GlobalCloudManager.getInstance().getCallback().getAccountId());
//        Requery.store().upsert(cloudAccount);
//    }
//
////    public List<CloudAccount> getAllAccounts() {
////        return Requery.rxStore().select(CloudAccount.class).get().toList();
////    }
//
//    public List<CloudAccount> getAvailableAccounts() {
//        long accountId = GlobalCloudManager.getInstance().getCallback().getAccountId();
//        return Requery.store().select(CloudAccount.class).where(CloudAccount.STATUS.eq(EnumCloudAcctStatus.NORMAL)).
//                and(CloudAccount.ACCOUNT_ID.eq(accountId)).get().toList();
//    }
//
//    public List<CloudAccount> getAllAccounts() {
//        long accountId = GlobalCloudManager.getInstance().getCallback().getAccountId();
//        List<CloudAccount> list = Requery.store().select(CloudAccount.class).where(CloudAccount.ACCOUNT_ID.eq(accountId)).get().toList();
//        printfCloudAccountList(list, "getAllAccounts");
//        return list;
//    }
//
//    public Map<Long, CloudAccount> getAllAccountsMap(QueryAttribute<CloudAccount, Long> queryAttribute) {
//        long accountId = GlobalCloudManager.getInstance().getCallback().getAccountId();
//        return Requery.store().select(CloudAccount.class).where(CloudAccount.ACCOUNT_ID.eq(accountId)).get().toMap(queryAttribute);
//    }
//
//    public CloudAccount getAccount(String site, String account) {
//        long accountId = GlobalCloudManager.getInstance().getCallback().getAccountId();
//        return Requery.rxStore().select(CloudAccount.class).where(CloudAccount.SITE.eq(site)).
//                and(CloudAccount.ACCOUNT.eq(account)).and(CloudAccount.ACCOUNT_ID.eq(accountId)).get().firstOrNull();
//    }
//
//    public CloudAccount getAccountById(long id) {
//        return Requery.store().findByKey(CloudAccount.class, id);
//    }
//
//    public void updateAcctStatusById(long id, EnumCloudAcctStatus status, boolean resetRefreshTime) {
//        if (resetRefreshTime) {
//            Requery.store().update(CloudAccount.class)
//                    .set(CloudAccount.STATUS, status)
//                    .set(CloudAccount.UPDATE_DATE, new Date())
//                    .set(CloudAccount.REMOTE_REFRESH_TIME, 0L)
//                    .where(CloudAccount.ID.eq(id))
//                    .get().value();
//        } else {
//            Requery.store().update(CloudAccount.class)
//                    .set(CloudAccount.STATUS, status)
//                    .set(CloudAccount.UPDATE_DATE, new Date())
//                    .where(CloudAccount.ID.eq(id))
//                    .get().value();
//        }
//    }
//
//    public void updateAllAccountStatus(EnumCloudAcctStatus status, boolean resetRefreshTime) {
//        long accountId = GlobalCloudManager.getInstance().getCallback().getAccountId();
//        List<CloudAccount> accountList = Requery.store().select(CloudAccount.class).
//                where(CloudAccount.ACCOUNT_ID.eq(accountId)).get().toList();
//        for (CloudAccount cloudAccount : accountList) {
//            if (resetRefreshTime) {
//                cloudAccount.setUpdateDate(new Date());
//                cloudAccount.setStatus(status);
//                cloudAccount.setRemoteRefreshTime(0L);
//                Requery.store().upsert(cloudAccount);
//            } else {
//                cloudAccount.setUpdateDate(new Date());
//                cloudAccount.setStatus(status);
//                Requery.store().upsert(cloudAccount);
//            }
//        }
//    }
//
//    public void removeAcctById(long id) {
//        Requery.store().delete(CloudAccount.class)
//                .where(CloudAccount.ID.eq(id))
//                .get().value();
//    }
//
//    public void removeAcctBefore(Date date) {
//        Requery.store().delete(CloudAccount.class)
//                .where(CloudAccount.UPDATE_DATE.lessThan(date))
//                .get().value();
//    }
//
//    public void removeAllAcct() {
//        long accountId = GlobalCloudManager.getInstance().getCallback().getAccountId();
//        Requery.store().delete(CloudAccount.class).where(CloudAccount.ACCOUNT_ID.eq(accountId)).get().value();
//    }
//
//    public void saveFolder(CloudFolder folder) {
//        Requery.store().upsert(folder);
//    }
//
//    public List<CloudFolder> getFoldersByAcct(String acctId) {
//        return Requery.store().select(CloudFolder.class)
//                .where(CloudFolder.ACCT_ID.eq(acctId))
//                .get().toList();
//    }
//
//    public void removeFolderById(String id) {
//        Requery.store().delete(CloudFolder.class)
//                .where(CloudFolder.ID.eq(id))
//                .get().value();
//    }
//
//    public void removeFoldersByAcctId(String accountId) {
//        Requery.store().delete(CloudFolder.class)
//                .where(CloudFolder.ACCT_ID.eq(accountId))
//                .get().value();
//    }
//
//    private void printfCloudAccountList(List<CloudAccount> cloudAccountList, String TAG2) {
//        if (!BuildConfig.DEBUG) return;
//        if (cloudAccountList == null || cloudAccountList.size() == 0) {
//            if (cloudAccountList == null)
//                TimberUtils.e("printfCloudAccountList: cloudAccountList is null!");
//            if (cloudAccountList != null && cloudAccountList.size() == 0)
//                TimberUtils.e("printfCloudAccountList: cloudAccountList is empty!");
//            return;
//        }
//        for (CloudAccount cloudAccount : cloudAccountList) {
//            printfCloudAccount(cloudAccount, TAG2);
//        }
//    }
//
//    private void printfCloudAccount(CloudAccount cloudAccount, String TAG2) {
//        if (!BuildConfig.DEBUG) return;
//        if (cloudAccount == null) {
//            TimberUtils.e("printfCloudAccount: cloudAccount is null!");
//            return;
//        }
//        Timber.d("       id:%s, accooutId:%s, alias:%s, site:%s, account:%s \n",
//                cloudAccount.getId(), cloudAccount.getAccountId(), cloudAccount.getAlias(),
//                cloudAccount.getSite(), cloudAccount.getAccount());
//    }
//}
