package com.mm.c.cloud.exception;

public class CloudException extends RuntimeException {
    private String detailMessage;

    public CloudException() {
        super();
    }

    public CloudException(String detailMessage) {
        super(detailMessage);
        this.detailMessage = detailMessage;
    }

    public CloudException(Throwable throwable) {
        super(throwable.getMessage());
    }

    @Override
    public String getMessage() {
        if (detailMessage == null || detailMessage.equals("")) {
            return super.getMessage();
        }
        return detailMessage;
    }
}
