package com.mm.c.cloud.help;

import com.mm.c.cloud.CloudAccount;
import com.mm.c.cloud.EnumCloudEventType;

/**
 * 网盘刷新事件
 */
public class CloudEvent<T> {
    private EnumCloudEventType type;
    private CloudAccount cloudAccount;
    private String message;
    private T data;


    public CloudEvent(EnumCloudEventType type, CloudAccount cloudAccount) {
        this(type, cloudAccount, null, null);
    }

    public CloudEvent(EnumCloudEventType type, CloudAccount cloudAccount, String message) {
        this(type, cloudAccount, message, null);
    }

    public CloudEvent(EnumCloudEventType type, CloudAccount cloudAccount, T data) {
        this(type, cloudAccount, null, data);
    }

    public CloudEvent(EnumCloudEventType type, CloudAccount cloudAccount, String message, T data) {
        this.type = type;
        this.cloudAccount = cloudAccount;
        this.message = message;
        this.data = data;
    }

    public CloudAccount getInfo() {
        return cloudAccount;
    }

    public EnumCloudEventType getType() {
        return type;
    }

    public T getData() {
        return data;
    }

    public String getMessage() {
        return message;
    }
}
