package com.mm.c.cloud.help;

import android.util.Pair;

import com.google.gson.Gson;
import com.mm.c.cloud.lib.logger.TimberUtils;
import com.mm.c.cloud.lib.misc.AppContextUtils;
import com.mm.c.cloud.lib.misc.utils.DirectoryUtils;
import com.mm.c.cloud.lib.misc.utils.FileUtils;
import com.mm.c.cloud.lib.misc.utils.MiscUtils;
import com.mm.c.cloud.manager.GlobalCloudManager;

import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class DNSMetricCollector {

    private static DNSMetricCollector instance;
    private File metricFile;
    private String name = "mfc_dns";
    private String appVer;

    private DNSMetricCollector() {
        File dir = new File(DirectoryUtils.getExternalDir());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        appVer = "" + MiscUtils.getVersionCode(AppContextUtils.getContext());
        metricFile = new File(DirectoryUtils.getExternalDir() + "metric");
    }

    public static DNSMetricCollector getInstance() {
        if (instance == null) {
            instance = new DNSMetricCollector();
        }
        return instance;
    }

    public void postFromFile() {
        if (!metricFile.exists()) {
            return;
        }
        Pair[] pairs = loadFromFile();
        if (pairs == null) {
            return;
        }
        try {
            for (Pair pair : pairs) {
                Map<String, String> tagMap = new HashMap<>();
                Map<String, Object> fieldMap = new HashMap<>();
                if (pair.first instanceof Map) {
                    for (Object object : ((Map) pair.first).entrySet()) {
                        if (object instanceof Map.Entry) {
                            Map.Entry entry = (Map.Entry) object;
                            tagMap.put(entry.getKey().toString(), entry.getValue().toString());
                        }
                    }
                }

                if (pair.second instanceof Map) {
                    for (Object object : ((Map) pair.second).entrySet()) {
                        if (object instanceof Map.Entry) {
                            Map.Entry entry = (Map.Entry) object;
                            fieldMap.put(entry.getKey().toString(), entry.getValue());
                        }
                    }
                }
            }
        } catch (Throwable throwable) {
            TimberUtils.e(throwable, "load metric from sd file failed");
        }
        metricFile.delete();
    }

    private Pair[] loadFromFile() {
        try {
            Gson gson = new Gson();
            if (metricFile.exists()) {
                String content = FileUtils.getFileContentEncrypt(metricFile);
                if (!StringUtils.isEmpty(content)) {
                    return gson.fromJson(content, Pair[].class);
                }
            }
        } catch (Throwable ex) {
            TimberUtils.e(ex, "read metric from sd file failed");
        }

        return new Pair[0];
    }

    public void postEvent(String host, String method, boolean result) {
        Map<String, String> tagMap = new LinkedHashMap<>();
        tagMap.put("ver", appVer);
        tagMap.put("mac", GlobalCloudManager.getInstance().getCallback().getMAC());
        tagMap.put("host", host);
        tagMap.put("method", method);

        Map<String, Object> fieldMap = new LinkedHashMap<>();
        fieldMap.put("result", Boolean.toString(result));

        if (!result) {
            saveToFile(new Pair<>(tagMap, fieldMap));
        } else {
            postFromFile();
        }
    }

    private void saveToFile(Pair<Map<String, String>, Map<String, Object>> metric) {
        try {
            Pair[] exists = loadFromFile();
            Pair[] newMetrics = new Pair[exists.length + 1];
            Gson gson = new Gson();

            int i = 0;
            for (Pair pair : exists) {
                newMetrics[i++] = pair;
            }
            newMetrics[i] = metric;

            String json = gson.toJson(newMetrics);
            FileUtils.stringToFileEncrypt(metricFile, json);
        } catch (Throwable e) {
            TimberUtils.e(e, "save metric to sd file failed");
        }
    }
}
