package com.mm.c.cloud.help;

import android.content.Context;
import android.os.Environment;
import android.os.StatFs;
import android.util.Log;

import com.mm.c.cloud.lib.device.BuildInfo;
import com.mm.c.cloud.lib.device.DeviceInfo;
import com.mm.c.cloud.lib.device.HardwareInfo;
import com.mm.c.cloud.lib.eventbus.BusProvider;
import com.mm.c.cloud.lib.eventbus.event.GrantedEvent;
import com.mm.c.cloud.lib.eventbus.event.NetworkEvent;
import com.mm.c.cloud.lib.logger.TimberUtils;
import com.mm.c.cloud.lib.misc.utils.GsonUtil;
import com.mm.c.cloud.lib.misc.utils.PermissionUtils;
import com.mm.c.cloud.manager.GlobalCloudManager;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by elegant.wang on 2017/12/8.
 */

public class DeviceManager {
    private static DeviceManager INSTANCE;
    private static final String KEY_CPUINFO = "cpuinfo";
    private static final String KEY_CPU_HARDWARE = "Hardware";
    private static final String KEY_CPU_SERIAL = "Serial";

    public static DeviceManager getInstance() {
        if (INSTANCE == null) {
            synchronized (DeviceManager.class) {
                if (INSTANCE == null) {
                    INSTANCE = new DeviceManager(GlobalCloudManager.getInstance().getCallback().getApplication());
                }
            }
        }
        return INSTANCE;
    }

    private Context context;
    private DeviceInfo deviceInfo;
    private boolean hasCheckThisTime = false;
    private String deviceInfoStr;

    private boolean initialized = false;
//    static {
//        IInitQuery.addItem(new IAction<Boolean>() {
//            @Override
//            public Boolean get() {
//                return INSTANCE != null;
//            }
//        });
//    }
//    public static void tear(){}
//    public static void init(Context context) {
//        INSTANCE = new DeviceManager(context);
//    }

    private DeviceManager(Context context) {
        this.context = context;
        BusProvider.getInstance().register(this);
    }

    private void ensureDeviceInfo() {
        if (initialized) {
            return;
        }
        synchronized (DeviceManager.class) {
            if (initialized) {
                return;
            }
            try {
                deviceInfo = new DeviceInfo(BuildInfo.getInstance(), HardwareInfo.getInstance());
                deviceInfoStr = GsonUtil.getGson().toJson(deviceInfo);
                initialized = true;
            } catch (Exception e) {
                Log.e("DeviceManager", "init device info", e);
            }
        }
    }

    private void initData() {
        ensureDeviceInfo();
    }


    public synchronized void checkAndPost() {
        if (hasCheckThisTime) return;
        if (!PermissionUtils.check(context, PermissionUtils.runtimePermissions)) {
            TimberUtils.e("has no enough permission");
            return;
        }
        initData();
    }

    public long getTotalRam() {
        RandomAccessFile reader = null;
        String load = null;
        long totRam = 0;
        try {
            reader = new RandomAccessFile("/proc/meminfo", "r");
            load = reader.readLine();

            Pattern p = Pattern.compile("(\\d+)");
            Matcher m = p.matcher(load);
            String value = "";
            while (m.find()) {
                value = m.group(1);
            }
            reader.close();

            totRam = Long.parseLong(value);

        } catch (IOException ex) {
            ex.printStackTrace();
        } finally {
            // Streams.close(reader);
        }

        return totRam;
    }

    public long getTotalRom() {
        StatFs stat = new StatFs(Environment.getExternalStorageDirectory().getPath());
        long bytesAvailable = stat.getBlockSizeLong() * stat.getBlockCountLong();
        long kbAvailable = bytesAvailable / 1024;
        return kbAvailable;
    }

    public Map<String, String> getCupInfo() {
        Map<String, String> cpuinfo = new HashMap<>();
        try {
            FileInputStream fis = new FileInputStream("/proc/cpuinfo");
            String cpuinfoStr = IOUtils.toString(fis);
            IOUtils.closeQuietly(fis);
            cpuinfo.put(KEY_CPUINFO, cpuinfoStr);
            LineNumberReader reader = new LineNumberReader(new StringReader(cpuinfoStr));
            String line;
            while ((line = reader.readLine()) != null) {
                String array[] = line.split(":");
                if (array.length == 2) {
                    String key = StringUtils.trimToEmpty(array[0]);
                    String value = StringUtils.trimToEmpty(array[1]);
                    if (KEY_CPU_HARDWARE.equalsIgnoreCase(key)) {
                        cpuinfo.put(KEY_CPU_HARDWARE, value);
                    } else if (KEY_CPU_SERIAL.equalsIgnoreCase(key)) {
                        cpuinfo.put(KEY_CPU_SERIAL, value);
                    }
                }
            }
        } catch (IOException e) {
            TimberUtils.e(e, "get cupinfo file error");
        }
        return cpuinfo;
    }

    public String getDeviceInfoStr() {
        ensureDeviceInfo();
        return deviceInfoStr;
    }

    public DeviceInfo getDeviceInfo() {
        ensureDeviceInfo();
        return deviceInfo;
    }

    @Subscribe(threadMode = ThreadMode.ASYNC)
    public void onNetworkEvent(NetworkEvent event) {
        checkAndPost();
    }

    @Subscribe(threadMode = ThreadMode.ASYNC)
    public void onGrantedEvent(GrantedEvent event) {
        checkAndPost();
    }
}
