package com.mm.c.cloud.help;

import com.google.gson.annotations.SerializedName;

import java.util.List;

/**
 * Created by elegant.wang on 2017/6/9.
 */
public class DnsOverHttpsDo {
    @SerializedName("Status")
    private int status; // NOERROR - Standard DNS response code (32 bit integer).
    private boolean TC; // Whether the response is truncated
    private boolean RD; // Always true for Google Public DNS
    private boolean RA; // Always true for Google Public DNS
    private boolean AD; // Whether all response data was validated with DNSSEC
    private boolean CD; // Whether the client asked to disable DNSSEC
    @SerializedName("Answer")
    private List<Answer> answers;

    @SerializedName("edns_client_subnet")
    private String clientSubnet;

    public int getStatus() {
        return status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean isTC() {
        return TC;
    }

    public void setTC(boolean TC) {
        this.TC = TC;
    }

    public boolean isRD() {
        return RD;
    }

    public void setRD(boolean RD) {
        this.RD = RD;
    }

    public boolean isRA() {
        return RA;
    }

    public void setRA(boolean RA) {
        this.RA = RA;
    }

    public boolean isAD() {
        return AD;
    }

    public void setAD(boolean AD) {
        this.AD = AD;
    }

    public boolean isCD() {
        return CD;
    }

    public void setCD(boolean CD) {
        this.CD = CD;
    }

    public List<Answer> getAnswers() {
        return answers;
    }

    public void setAnswers(List<Answer> answers) {
        this.answers = answers;
    }

    public String getClientSubnet() {
        return clientSubnet;
    }

    public void setClientSubnet(String clientSubnet) {
        this.clientSubnet = clientSubnet;
    }

    public static class Answer {
        private String name;
        private int type;
        @SerializedName("TTL")
        private int ttl;
        private String data;

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getType() {
            return type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public int getTtl() {
            return ttl;
        }

        public void setTtl(int ttl) {
            this.ttl = ttl;
        }

        public String getData() {
            return data;
        }

        public void setData(String data) {
            this.data = data;
        }
    }
}
