package com.mm.c.cloud.help;

import com.facebook.stetho.okhttp.StethoInterceptor;
import com.mm.c.cloud.lib.api.UrlProvider;
import com.mm.c.cloud.BuildConfig;
import com.mm.c.cloud.interceptor.ApiCipherInterceptor;
import com.mm.c.cloud.interceptor.MultiBaseUrlRetryInterceptor;
import com.mm.c.cloud.interceptor.SsoTokenInterceptor;
import com.mm.c.cloud.lib.eventbus.BusProvider;
import com.mm.c.cloud.lib.logger.TimberUtils;
import com.mm.c.cloud.lib.misc.utils.JsonUtil;
import com.mm.c.cloud.manager.GlobalCloudManager;
import com.squareup.okhttp.Dns;
import com.squareup.okhttp.OkHttpClient;
import com.mm.c.cloud.lib.common.utils.HttpUtils;
import com.valor.mfc.vms.api.model.common.response.ResponseStatus;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.concurrent.TimeUnit;

import javax.net.ssl.SSLContext;

import retrofit.RetrofitError;

/**
 * RetrofitHelper
 */
public class RetrofitHelper {
    //构造一个OkHttpClient供retrofit使用
    public static OkHttpClient createOkHttpClient() {

        SSLContext sslContext = HttpUtils.getSslContext();
        OkHttpClient client = new OkHttpClient();
        if (sslContext != null) {
            // 设置忽略ssl证书
            client.setSslSocketFactory(sslContext.getSocketFactory());
        }
        client.setHostnameVerifier((hostname, session) -> true);
        //调试模式下添加stetho interceptor
        if (BuildConfig.DEBUG) {
            client.networkInterceptors().add(new StethoInterceptor());//集成Stetho网络调试工具
        }
        //client.networkInterceptors().add(new GzipRequestInterceptor());//gzip压缩请求
        client.setConnectTimeout(60, TimeUnit.SECONDS);//BuildConfig.HTTP_API_CONNECT_TIMEOUT
        client.setReadTimeout(60, TimeUnit.SECONDS);//BuildConfig.HTTP_API_READ_TIMEOUT
        //去除缓存
        //client.setCache(new Cache(new File(MyApplication.getInstance().getCacheDir(), "http_cache"), Constant.HTTP_CACHE_SIZE));
        client.setDns(new EnhancedDns());
        return client;
    }

    public static int getRetrofitApiHttpCode(Throwable error) {
        if (!(error instanceof RetrofitError)) return -1;
        RetrofitError retrofitError = (RetrofitError) error;
        try {
            if (retrofitError == null || retrofitError.getResponse() == null || retrofitError.getResponse().getStatus() != 555) {
                return -1;
            }
            // 这里可能出异常所以try catch
            ResponseStatus responseStatus = (ResponseStatus) retrofitError.getBodyAs(ResponseStatus.class);
            return responseStatus.getErrCode();
        } catch (Exception e) {
            return -1;
        }
    }

    public static void checkBeenRemoved(String responseJson){
        String retCode = JsonUtil.getFieldValue(responseJson,"retCode");
        String errCode = JsonUtil.getFieldValue(responseJson,"errCode");

        //说明当前用户被服务器其它账号挤下线了
        if("2".equals(retCode) && "225".equals(errCode) && GlobalCloudManager.getInstance().getCallback().isLoggedIn()){
            BusProvider.getInstance().post(new BeRemovedEvent());
        }
    }

    public static OkHttpClient clientSsoCipher(UrlProvider urlProvider) {
        OkHttpClient client = createOkHttpClient();
        client.interceptors().add(new SsoTokenInterceptor());
        client.interceptors().add(new ApiCipherInterceptor());
        client.interceptors().add(new MultiBaseUrlRetryInterceptor(urlProvider));
        return client;
    }

    public static OkHttpClient clientCipher(UrlProvider urlProvider) {
        OkHttpClient client = createOkHttpClient();
        client.interceptors().add(new ApiCipherInterceptor());
        client.interceptors().add(new MultiBaseUrlRetryInterceptor(urlProvider));
        return client;
    }

    public static class EnhancedDns implements Dns {

        @Override
        public List<InetAddress> lookup(String hostname) throws UnknownHostException {
            try {
                List<InetAddress> list = Dns.SYSTEM.lookup(hostname);
                DNSMetricCollector.getInstance().postFromFile();
                return list;
            } catch (UnknownHostException e) {
                TimberUtils.e(e, "system default dns resolver error , try dns java");
                DNSMetricCollector.getInstance().postEvent(hostname, "sys", false);
                List<InetAddress> list = DnsService.getInstance().lookup(hostname);
                return list;
            }
        }
    }
}
