package com.mm.c.cloud.help;

import android.text.TextUtils;

import com.mm.c.cloud.BuildConfig;
import com.mm.c.cloud.lib.common.preferences.UserPreferences;
import com.mm.c.cloud.lib.misc.utils.DirectoryUtils;
import com.mm.c.cloud.manager.GlobalCloudManager;
import com.mm.c.cloud.server.HostProvider;

import org.apache.commons.lang3.StringUtils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class UrlUtils {

    private static String HOST = GlobalCloudManager.getInstance().getCallback().getHost();
    private static String APPWEB_HOST = GlobalCloudManager.getInstance().getCallback().getAppWebHost();
    private static String CLOUDSYNC_HOST = GlobalCloudManager.getInstance().getCallback().getCloudSyncHost();
    private static String NS_HOST = GlobalCloudManager.getInstance().getCallback().getNsHost();
    private static String WEB_HOST_KEY = "web";//BuildConfig.WEB_HOST_KEY;

    public class ConnectKey {
        public static final String HOST = "mfc.meta_host";
        public static final String APP_WEB_HOST = "mfc.meta_appweb_host";
        public static final String CLOUDSYNC_HOST = "mfc.meta_cloudsync_host";
        public static final String NS_HOST = "mfc.ns_host";
    }

    public class PreferenceConstant {
        public static final String URL_HOST = "url_host";
        public static final String URL_APPWEB_HOST = "url_appweb_host";
        public static final String URL_CLOUDSYNC_HOST = "url_cloudsync_host";
        public static final String URL_NS_HOST = "url_ns_host";
    }

    public static List<String> getHost() {
        return getCfgHost(ConnectKey.HOST, PreferenceConstant.URL_HOST, HOST);
    }

    public static List<String> getCloudsyncHost() {
        return getCfgHost(ConnectKey.CLOUDSYNC_HOST, PreferenceConstant.URL_CLOUDSYNC_HOST, CLOUDSYNC_HOST);
    }

    public static List<String> getNSHost() {
        return getCfgHost(ConnectKey.NS_HOST, PreferenceConstant.URL_NS_HOST, NS_HOST);
    }

    public static String getAppWebHost() {
        List<String> hosts = getCfgHost(ConnectKey.APP_WEB_HOST, PreferenceConstant.URL_APPWEB_HOST, APPWEB_HOST);
        HostProvider provider = new HostProvider(WEB_HOST_KEY, hosts);
        return provider.url();
    }

    private static List<String> getCfgHost(String propertiesKey, String preferenceKey, String defaultHost) {
        List<String> hosts = new ArrayList<>();
        if (getProperties() != null && properties.containsKey(propertiesKey)) {
            String url = getPropertyValue(propertiesKey);
            if (isValid(url)) {
                hosts.add(url);
            }
        }

        String url = UserPreferences.getInstance().getString(preferenceKey);
        if (isValid(url) && !hosts.contains(url)) {
            hosts.add(url);
        }
        List<String> list = Arrays.asList(defaultHost.split(","));
        for (String host : list) {
            if (!hosts.contains(host)) {
                hosts.add(host);
            }
        }
        return hosts;
    }

    private static boolean isValid(String url) {
        return !TextUtils.isEmpty(url) && (StringUtils.startsWithIgnoreCase(url, "http://") || StringUtils.startsWithIgnoreCase(url, "https://"));
    }

    /*设置文件连接属性*/
    private static Properties properties = null;

    public static Properties getProperties() {
        if (null == properties) {
            if (BuildConfig.DEBUG) {
                File file = new File(DirectoryUtils.getPublicDir() + "valor.properties");
                if (file.exists()) {
                    try {
                        BufferedReader br = new BufferedReader(new FileReader(file));
                        if (properties == null) {
                            properties = new Properties();
                        }
                        properties.load(br);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return properties;
    }

    public static void setProperties(Properties properties) {
        UrlUtils.properties = properties;
    }

    public static String getPropertyValue(String key) {
        return getProperties().getProperty(key);
    }

    public static List<String> getAppWebHostList() {
        return getCfgHost(ConnectKey.APP_WEB_HOST, PreferenceConstant.URL_APPWEB_HOST, APPWEB_HOST);
    }
}
