package com.mm.c.cloud.help;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.provider.Settings.System;
import android.text.TextUtils;
import android.text.format.Time;
import android.util.Base64;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.mm.c.cloud.BuildConfig;
import com.mm.c.cloud.R;
import com.mm.c.cloud.lib.ui.dialog.LiveLoadingDialog;
import com.mm.c.cloud.lib.ui.dialog.LoadingDialog;
import com.mm.c.cloud.manager.GlobalCloudManager;
import com.mm.c.cloud.lib.logger.Logger;
import com.mm.c.cloud.lib.logger.TimberUtils;
import com.mm.c.cloud.lib.device.HardwareInfo;
import com.mm.c.cloud.lib.misc.utils.GsonUtil;
import com.mm.c.cloud.lib.misc.utils.LruCacheUtils;
import com.mm.c.cloud.lib.misc.utils.ToastCompatUtils;
import com.mm.c.cloud.lib.common.asynctask.ActionDelegate;
import com.mm.c.cloud.lib.common.asynctask.AsyncUtils;
import com.mm.c.cloud.lib.common.asynctask.UICallback;
import com.valor.mfc.vms.api.common.encrypt.MD5Checksum;

import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import timber.log.Timber;

/**
 * @author joychang
 * @Description 应用工具类
 */
public class Utils {

    public static String getPublishDate(int daysBeforeToday) {
        if (daysBeforeToday < 1) {
            return "today";
        } else if (daysBeforeToday < 2) {
            return "yesterday";
        } else if (daysBeforeToday < 7) {
            return daysBeforeToday + " days ago";
        } else if (daysBeforeToday < 14) {
            return "1 week ago";
        } else if (daysBeforeToday < 21) {
            return "2 weeks ago";
        } else if (daysBeforeToday < 28) {
            return "3 weeks ago";
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            calendar.add(Calendar.DAY_OF_YEAR, -daysBeforeToday);
            return calendar.get(Calendar.DAY_OF_MONTH) + "/" +
                    (calendar.get(Calendar.MONTH) + 1) + "/" +
                    calendar.get(Calendar.YEAR);
        }
    }

    /**
     * 最省内存的方式读取本地图片
     */
    public static Bitmap readBitMap(Context context, int resId) {
        BitmapFactory.Options opt = new BitmapFactory.Options();
        opt.inPreferredConfig = Bitmap.Config.RGB_565;
        opt.inPurgeable = true;
        opt.inInputShareable = true;
        // 获取资源图片  
        InputStream is = context.getResources().openRawResource(resId);
        return BitmapFactory.decodeStream(is, null, opt);
    }

    public static View changeTextViewLeftDrawable(View view, Drawable drawable) {
        TextView textView = getTextView(view);
        if (textView == null)
            return null;

        drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());
        textView.setCompoundDrawables(drawable, null, null, null);
        return textView;
    }

    public static View checkedTextView(View view, View lastView, int checkedColor, int normalColor) {
        TextView textView = getTextView(view);
        if (textView == null)
            return null;

        if (lastView != null && lastView instanceof TextView)
            ((TextView) lastView).setTextColor(normalColor);

        textView.setTextColor(checkedColor);

        return textView;
    }

    public static void checkedTextView(View view, boolean isChecked, int checkedColor, int normalColor) {
        TextView textView = getTextView(view);
        if (textView == null)
            return;

        if (isChecked) {
            textView.setTextColor(checkedColor);
        } else {
            textView.setTextColor(normalColor);
        }
    }

    private static TextView getTextView(View view) {
        if (view == null)
            return null;

        if (view instanceof TextView) {
            return (TextView) view;
        } else {
            if (!(view instanceof RelativeLayout))
                return null;

            RelativeLayout relativeLayout = (RelativeLayout) view;
            if (relativeLayout.getChildCount() < 1)
                return null;

            if (!(relativeLayout.getChildAt(0) instanceof TextView))
                return null;

            return (TextView) relativeLayout.getChildAt(0);
        }
    }

    /**
     * 读取配置文件 3.20
     */
    public static String getFormInfo(Class c, int i) {
        String frominfo = "";
        Properties prop = new Properties();
        try {
            prop.load(c.getResourceAsStream("/assets/config.properties"));
        } catch (Exception e) {
            e.printStackTrace();
        }
        String from[] = ((String) prop.get("from")).split("[|]");
        frominfo = from[i];
        return frominfo;

    }

    /**
     * @brief 显示函数。
     * @author joychang
     * @param[in] context 上下文。
     * @param[in] message 内容文字。
     * @note 显示加载对话框处理。
     */
    public static void loadingShow(Context context, String message) {
        if (lDialog != null) {
            loadingClose();
            //return;
            // 关闭加载框
        }

        // 使用以下方式显示对话框，按返回键可关闭对话框
        lDialog = new LoadingDialog(context, message);
        lDialog.setMessage(message);
        // lDialog.setIndeterminate(true);
        lDialog.setCancelable(true);
        lDialog.setCanceledOnTouchOutside(false);
        lDialog.show();
    }

    /**
     * @brief 关闭函数。
     * @author joychang
     * @note 关闭加载对话框处理。
     */
    public static void loadingClose() {
        loadingClose(0);
    }

    public static void loadingClose(int delay) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                if (null != lDialog) {
                    lDialog.dismiss();
                    lDialog.cancel();
                    lDialog = null;
                } else {
                    Timber.w("close(): LoadingDialog is not showing");
                }

                Timber.d("LoadingDialog close() end");
            }
        }, delay);
    }

    /**
     * 设置加载对话框的显示消息
     *
     * @param resId 消息的资源id
     */
    public static void setLoadingMsg(int resId) {
        if (lDialog != null) {
            lDialog.setLoadingMsg(resId);
        }
    }

    /**
     * 设置加载对话框的显示消息
     *
     * @param msg 消息内容
     */
    public static void setLoadingMsg(String msg) {
        if (lDialog != null) {
            lDialog.setLoadingMsg(msg);
        }
    }

    /**
     * 获得网络连接是否可用
     */
    public static boolean hasNetwork(Context context) {
//        ConnectivityManager con = (ConnectivityManager) context
//                .getSystemService(Context.CONNECTIVITY_SERVICE);
//        NetworkInfo workinfo = con.getActiveNetworkInfo();
//        if (workinfo == null || !workinfo.isAvailable()) {
//            //showNetDialog(context);
//            return false;
//        }
        return true;
    }

    /**
     * 安装一个apk文件
     */
    public static void installApk(File file, Context context) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.setDataAndType(Uri.fromFile(file),
                "application/vnd.android.package-archive");
        context.startActivity(intent);
    }

    /**
     * 获取当前应用版本号
     * 返回1.1.1
     */
    @SuppressWarnings("unused")
    public static String getVersion(Context context) {
        PackageManager pm = context.getPackageManager();
        try {
            PackageInfo info = pm.getPackageInfo(context.getPackageName(), 0);
            return info.versionName;
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    /**
     * 获取当前时间
     *
     * @return 时间字符串 24小时制
     * @author drowtram
     */
    public static String getStringTime(String type) {
        Time t = new Time();
        t.setToNow(); // 取得系统时间。
        String hour = t.hour < 10 ? "0" + (t.hour) : t.hour + ""; // 默认24小时制
        String minute = t.minute < 10 ? "0" + (t.minute) : t.minute + "";
        return hour + type + minute;
    }

    public static String makeMD5(String password) {
        MD5Checksum md5Checksum = new MD5Checksum();
        md5Checksum.update(password);
        return md5Checksum.getChecksum();
    }

    /**
     * menu主界面目录
     */
    public static ArrayList<String> getUserData(int type, Context context) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(context.getString(R.string.cloud_delete));
        list.add(context.getString(R.string.cloud_delete_all));
//		if (type == REMOVE_FROM_FAV) {
//			list.add("从常用中删除");
//			list.add("卸载");
//		} else if (type == ADD_TO_FAV) {
//			list.add("添加到常用");
//			list.add("卸载");
//		}

        return list;
    }

    /**************************回看工具函数*******************************/


    /**
     * @param strLink 链接地址
     * @return false     该地址非空
     * @brief 判断该链接是否为空
     * @author joychang
     */
    public static boolean isValidLink(String strLink) {
        Log.d("UiUtil", "isValidLink() start.");
        boolean result = false;
        if (strLink != null && strLink.length() > 0) {
            URL url;
            try {
                url = new URL(strLink);
                HttpURLConnection connt = (HttpURLConnection) url.openConnection();
                connt.setConnectTimeout(5 * 1000);
                connt.setRequestMethod("HEAD");
                int code = connt.getResponseCode();
                if (code == 404) {
                    result = true;
                }
                connt.disconnect();
            } catch (Exception e) {
                result = true;
            }
        } else {
            result = true;
        }
        Log.d("UiUtil", "isValidLink() end.");
        return result;
    }


    /**
     * 获取加密字符
     * @param url
     * @return
     */
//	public static String getMd5Pass(final String url) {
//		DefaultHttpClient client = new DefaultHttpClient();
//		HttpGet get = new HttpGet(url);
//		HttpParams params = new BasicHttpParams();//
//		params = new BasicHttpParams();
//		HttpConnectionParams.setConnectionTimeout(params, 3000); // 连接超时
//		HttpConnectionParams.setSoTimeout(params, 3000); // 响应超时
//		get.setParams(params);
//		// post.setHeader("Accept-Ranges", "bytes");
//		Object obj = null;
//		try {
//			HttpResponse response = client.execute(get);// 包含响应的状态和返回的结果==
//			if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
//				String jsonStr = EntityUtils.toString(response.getEntity(),
//						"UTF-8");
//				JSONObject jo = new JSONObject(jsonStr);
//				jsonStr = jo.getString("stime");
//				// TODO:
//				Logger.d(TAG, jsonStr);
//				return jsonStr;
//			}
//		} catch (ClientProtocolException e) {
//			Logger.e(TAG, e.getLocalizedMessage());
//		} catch (IOException e) {
//			Logger.e(TAG, e.getLocalizedMessage());
//		} catch (Exception e) {
//			Logger.e(TAG, e.getLocalizedMessage());
//		}finally {
//
//		}
//		return "";
//	}

    /**
     * @return UTF8形式字符串。
     * @throws UnsupportedEncodingException 不支持的字符集
     * @brief 中文字符串转换函数。
     * @author joychang
     * @param[in] str 要转换的字符串。
     * @param[in] charset 字符串编码。
     * @note 将str中的中文字符转换为UTF8编码形式。
     */
    public static String encode(String str, String charset) throws UnsupportedEncodingException {
        Log.d(TAG, "_encode() start");

        String result = null;

        if ((str != null) && (charset != null)) {
            try {
                Pattern p = Pattern.compile(DEF_ZH_PATTERN, 0);
                Matcher m = p.matcher(str);

                StringBuffer b = new StringBuffer();
                while (m.find()) {
                    m.appendReplacement(b, URLEncoder.encode(m.group(0), charset));
                }

                m.appendTail(b);

                result = b.toString();
            } catch (PatternSyntaxException e) {
                e.printStackTrace();
            }
        } else {
            if (str == null) {
                Log.e(TAG, "encode(): str is null");
            }

            if (charset == null) {
                Log.e(TAG, "encode(): charset is null");
            }
        }

        Log.d(TAG, "encode() end");

        return result;
    }

    /**
     * @brief 显示函数。
     * @author joychang
     * @param[in] context 上下文。
     * @param[in] message 内容文字。
     * @note 显示加载对话框处理。
     */
    public static void loadingShow_tv(Context context, int message) {
        loadingShow_tv(context, context.getString(message));
    }

    public static void loadingShow_tv(Context context, String message) {
        Log.d(TAG, "show() start");
        if (Loadingdialog != null && Loadingdialog.isShowing()) {
            Loadingdialog.dismiss();
            //Loadingdialog = null;
        }
        //使用以下方式显示对话框，按返回键可关闭对话框
        Loadingdialog = new LiveLoadingDialog(context);
        Loadingdialog.setLoadingMsg(message);
        Loadingdialog.setCanceledOnTouchOutside(false);
        Loadingdialog.show();
        Log.d(TAG, "show() end");
    }

    /**
     * @brief 关闭函数。
     * @author joychang
     * @note 关闭加载对话框处理。
     */
    public static void loadingClose_Tv() {
        Log.d(TAG, "close() start");
        if (Loadingdialog != null) {
            Loadingdialog.cancel();
            Loadingdialog = null;
        } else {
            Log.w(TAG, "close(): mDialog is not showing");
        }

        Log.d(TAG, "close() end");
    }

    /**
     * @return false 对话框非显示中。
     * @brief 判断加载对话框是否显示函数。
     * @author joychang
     */
    public static boolean isShowing() {
        Log.d(TAG, "isShowing() start");

        boolean result = false;

        if (Loadingdialog != null) {
            result = true;
        }

        Log.d(TAG, "isShowing() end");

        return result;
    }

    /**
     * 根据日期获取对应的星期
     *
     * @return 星期
     */
    public static String getWeekToDate(String mdate) {
        String week = null;
        mdate = mdate.replace("/", "-");
//    	mdate = mdate.replace("月", "-");
//    	mdate = mdate.replace("日", "");
//    	mdate = "2014-"+mdate;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = sdf.parse(mdate);
            week = getWeek(date);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return week;
    }

    public static String getWeek(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("EEEE");
        String week = sdf.format(date);
        return week;
    }

    /**
     * 根据节目Url获取节目的时间
     *
     * @param src 节目地址
     * @return 时间
     */
    public static String getTimeToSrc(String src) {
        String time = null;
        String stringarray[] = src.split("-");
        String srcnew = stringarray[0];
        String timenew = srcnew.substring(srcnew.length() - 4, srcnew.length());
        String start = timenew.substring(0, 2);
        String end = timenew.substring(timenew.length() - 2, timenew.length());
        time = start + ":" + end;
        return time;
    }

    /**
     * 根据label名字截取时间
     */
    public static String getTimeToLabel(String label) {
        String time = "";
        if (label.length() > 5) {
            time = label.substring(0, 5);
        }
        return time;
    }

    /**
     * 根据label名字截取名字
     */
    public static String getNameToLabel(String label) {
        String name = "";
        if (label.length() > 6) {
            name = label.substring(6, label.length());
        }
        return name;
    }

    /**
     * 时间格式转换
     */
    public static String toTime(int time) {

        time /= 1000;
        int minute = time / 60;
        int hour = minute / 60;
        int second = time % 60;
        minute %= 60;
        return String.format("%02d:%02d:%02d", hour,
                minute, second);
    }

    /**
     * date类型时间转换成标准的日期格式
     */
    public static String dateToString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yy/MM/dd HH:mm:ss");
        return sdf.format(date);
    }

    public static String dateToString(long dateLong) {
        Date date = new Date(dateLong);
        return dateToString(date);
    }

    private void updateTextViewWithTimeFormat(TextView view, int second) {
        int hh = second / 3600;
        int mm = second % 3600 / 60;
        int ss = second % 60;
        String strTemp = null;
        if (0 != hh) {
            strTemp = String.format("%02d:%02d:%02d", hh, mm, ss);
        } else {
            strTemp = String.format("%02d:%02d", mm, ss);
        }
        view.setText(strTemp);
    }

    /**
     * 从Assets目录下拷贝文件到指定目录
     *
     * @param context  上下文对象
     * @param fileName Assets目录下的指定文件名
     * @param path     要拷贝到的目录
     * @return true 拷贝成功  false 拷贝失败
     * @author drowtram
     */
    public static boolean copyApkFromAssets(Context context, String fileName, String path) {
        boolean copyIsFinish = false;
        try {
            File f = new File(path);
            if (f.exists()) {
                f.delete(); //如果存在这个文件，则删除重新拷贝
            }
            InputStream is = context.getAssets().open(fileName);
            File file = new File(path);
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            byte[] temp = new byte[1024];
            int i = 0;
            while ((i = is.read(temp)) > 0) {
                fos.write(temp, 0, i);
            }
            fos.close();
            is.close();
            copyIsFinish = true;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return copyIsFinish;
    }

    /**
     * 获取一个路径的文件名
     */
    public static String getFilename(String urlpath) {
        return urlpath
                .substring(urlpath.lastIndexOf("/") + 1, urlpath.length());
    }


//    /***************************点播工具***********************************/
//    /**
//     * 获取底部的剧集数据
//     *
//     * @param datas list或grid
//     */
//    public static List<String> getVideoBottomDatas(List<VodUrl> datas,
//                                                   int index, Boolean isList) {
//        List<String> gv_list = null;
//        if (isList) {
//            int j = index * 10;
//            for (int i = 0; i < 10; i++) {
//                gv_list.add("第" + (j + i + 1) + "集" + "-"
//                        + datas.get(j + i).getTitle());
//            }
//        } else {
//            gv_list = new ArrayList<String>();
//            datas.size();
//            int i = 0;
//            int j = datas.size() / 10;
//            while (true) {
//                if (i < j) {
//                    gv_list.add(i * 10 + 1 + "-" + (i + 1) * 10);
//                    i++;
//                } else {
//                    gv_list.add(i * 10 + 1 + "-" + datas.size());
//                    return gv_list;
//                }
//            }
//        }
//        return gv_list;
//    }

//    public static List<VodUrl> getVideolvDatas(List<VodUrl> datas, int index) {
//        List<VodUrl> lv_list = new ArrayList<VodUrl>();
//        int j = index * 10;
//        if (null != datas && datas.size() - j >= 10) {
//            for (int i = 0; i < 10; i++) {
//                VodUrl vodurl = new VodUrl();
//                vodurl.setTitle((j + i + 1) + "-"
//                        + datas.get(j + i).getTitle());
//                vodurl.setUrl(datas.get(j + i).getUrl());
//                lv_list.add(vodurl);
//            }
//        } else {
//            for (int i = 0; i < datas.size() - j; i++) {
//                VodUrl vodurl = new VodUrl();
//                vodurl.setTitle((j + i + 1) + "-"
//                        + datas.get(j + i).getTitle());
//                vodurl.setUrl(datas.get(j + i).getUrl());
//                lv_list.add(vodurl);
//            }
//        }
//
//        return lv_list;
//    }
//
//    public static List<String> getVideogvDatas(List<VodUrl> datas,
//                                               Boolean isList) {
//        List<String> gv_list = new ArrayList<String>();
//        datas.size();
//        int i = 0;
//        int j = datas.size() / 10;
//        while (true) {
//            if (i < j) {
//                gv_list.add(i * 10 + 1 + "-" + (i + 1) * 10);
//                i++;
//            } else if (i * 10 + 1 <= datas.size()) {
//                gv_list.add(i * 10 + 1 + "-" + datas.size());
//                return gv_list;
//            } else {
//                return gv_list;
//            }
//        }
//    }

    public static List<String> getVideogvDatas(int size,
                                               Boolean isList) {
        List<String> gv_list = new ArrayList<String>();
        int i = 0;
        int j = size / 10;
        while (true) {
            if (i < j) {
                gv_list.add(i * 10 + 1 + "-" + (i + 1) * 10);
                i++;
            } else if (i * 10 + 1 <= size) {
                gv_list.add(i * 10 + 1 + "-" + size);
                return gv_list;
            } else {
                return gv_list;
            }
        }
    }

    /**
     * <p>
     * 将字符串使用base64加密
     * </p>
     *
     * @param url 路径
     */
    public static String encodeBase64String(String url) throws Exception {
        return Base64.encodeToString(url.getBytes(),
                Base64.DEFAULT);
    }

    /**
     * 筛选条件编码
     */
    public static String getEcodString(String filter) {
        String s = "";
        try {
            s = URLEncoder.encode(filter, "utf-8");
        } catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        return s;
    }

    // 改变亮度
    public static void SetLightness(Activity act, int value) {
        try {
            System.putInt(act.getContentResolver(), System.SCREEN_BRIGHTNESS, value);
            WindowManager.LayoutParams lp = act.getWindow().getAttributes();
            lp.screenBrightness = (value <= 0 ? 1 : value) / 255f;
            //lp.screenBrightness = value <= 0 ? 1 : value;
            Logger.d("doBrightnessTouch", "SetLightness====" + lp.screenBrightness);
            act.getWindow().setAttributes(lp);
        } catch (Exception e) {
            ToastCompatUtils.showToast(act, "无法改变亮度", Toast.LENGTH_SHORT);
        }
    }

    // 获取亮度
    public static float GetLightness(Activity act) {
        Logger.d("doBrightnessTouch", "GetLightness====" + System.getFloat(act.getContentResolver(),
                System.SCREEN_BRIGHTNESS, -1));
        return System.getFloat(act.getContentResolver(),
                System.SCREEN_BRIGHTNESS, -1) / 255f;
//		return System.getInt(act.getContentResolver(),
//				System.SCREEN_BRIGHTNESS, -1);
    }

    // 停止自动亮度调节
    public static void stopAutoBrightness(Activity activity) {
        System.putInt(activity.getContentResolver(),
                System.SCREEN_BRIGHTNESS_MODE,
                System.SCREEN_BRIGHTNESS_MODE_MANUAL);
    }

    // 开启亮度自动调节
    public static void startAutoBrightness(Activity activity) {
        System.putInt(activity.getContentResolver(),
                System.SCREEN_BRIGHTNESS_MODE,
                System.SCREEN_BRIGHTNESS_MODE_AUTOMATIC);
    }

    /**
     * 删除指定目录下所有apk文件
     *
     * @author drowtram
     */
    public static void deleteAppApks(String dir) {
        File file = new File(dir);
        try {
            if (file.exists() && file.isDirectory()) {
                File[] files = file.listFiles();
                for (File f : files) {
                    String fileName = f.getName();
                    if (f.isFile() && fileName.endsWith(".apk")) {
                        if (f.delete()) {
                            Log.d("zhouchuan", "delete the " + fileName);
                        }
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * 下载apk文件进行安装
     *
     * @param mHandler 更新显示进度的handler
     * @author drowtram
     */
    public static void startDownloadApk(final Context context, final String url, final Handler mHandler) {
        //todo 编译不过，暂时屏蔽
//		ToastUtils.showToast(context, "正在后台下载，完成后提示安装...", R.drawable.toast_smile);
//		new Thread(new Runnable() {
//			@Override
//			public void run() {
////				File file = new File(Constant.PUBLIC_DIR);
//				String apkName = url.substring(url.lastIndexOf("/")+1);
////				File file = new File(context.getCacheDir(),apkName);
//				Log.d("zhouchuan", "文件路径"+apkName);
////				if(!file.exists()){
////					file.mkdirs();
////				}
//				FileOutputStream fos = null;
//				try {
//					HttpGet hGet = new HttpGet(url.replaceAll(" ", "%20"));//替换掉空格字符串，不然下载不成功
//					HttpResponse hResponse = new DefaultHttpClient().execute(hGet);
//					if(hResponse.getStatusLine().getStatusCode() == 200){
//						InputStream is = hResponse.getEntity().getContent();
//						float downsize = 0;
//						if(mHandler != null) {
//							//获取下载的文件大小
//							float size = hResponse.getEntity().getContentLength();
//							mHandler.obtainMessage(1001, size).sendToTarget();//发消息给handler处理更新信息
//						}
//						fos = context.openFileOutput(apkName, Context.MODE_WORLD_READABLE|Context.MODE_WORLD_WRITEABLE);
//						byte[] buffer = new byte[8192];
//						int count = 0;
//						while ((count = is.read(buffer)) != -1) {
//							if(mHandler != null) {
//								downsize += count;
//								mHandler.obtainMessage(1002, downsize).sendToTarget();//发消息给handler处理更新信息
//							}
//							fos.write(buffer, 0, count);
////							Log.d("zhouchuan", "下载进度"+(int)(downsize/size*100)+"%"+" downsize="+downsize+" size="+size);
//					    }
//						fos.close();
//						is.close();
//						installApk(context,"/data/data/com.valor.mfc.droid.tvapp/files/" + apkName);
//					}
//				} catch (Exception e) {
//					e.printStackTrace();
//				}
//			}
//		}).start();
    }


    /**
     * 安装apk文件
     *
     * @author drowtram
     */
    public static void installApk(Context context, String fileName) {
        if (getUninatllApkInfo(context, fileName)) {
            File updateFile = new File(fileName);
            try {
                String[] args2 = {"chmod", "604", updateFile.getPath()};
                Runtime.getRuntime().exec(args2);
            } catch (IOException e) {
                e.printStackTrace();
            }
            /*------------------------*/
            Intent intent = new Intent(Intent.ACTION_VIEW);
            intent.setDataAndType(Uri.fromFile(updateFile),
                    "application/vnd.android.package-archive");
            context.startActivity(intent);
//			File file = new File(fileName);
//			Intent intent = new Intent();
//			intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
//			intent.setAction(Intent.ACTION_VIEW);     //浏览网页的Action(动作)
//			String type = "application/vnd.android.package-archive";
//			intent.setDataAndType(Uri.fromFile(file), type);  //设置数据类型
//			context.startActivity(intent);
        } else {
            ToastCompatUtils.showToast(context, "文件还没下载完成，请耐心等待。", Toast.LENGTH_SHORT);
        }
    }

    /**
     * 判断apk文件是否可以安装
     */
    public static boolean getUninatllApkInfo(Context context, String filePath) {
        boolean result = false;
        try {
            PackageManager pm = context.getPackageManager();
            PackageInfo info = pm.getPackageArchiveInfo(filePath, PackageManager.GET_ACTIVITIES);
            if (info != null) {
                result = true;
            }
        } catch (Exception e) {
            result = false;
            Log.e("zhouchuan", "*****  解析未安装的 apk 出现异常 *****" + e.getMessage(), e);
        }
        return result;
    }

    /**
     * 获取当前日期，包含星期几
     *
     * @return 日期字符串 xx月xx号 星期x
     * @author drowtram
     */
    public static String getStringDate(Context context) {
        final Calendar c = Calendar.getInstance();
        final Resources res = context.getResources();
        final String[] weekDayNames = res.getStringArray(R.array.week_day_names);
        final String[] monthNames = res.getStringArray(R.array.month_names);
        final String timeZone = res.getString(R.string.time_zone);
        String monthDayName = res.getString(R.string.str_empty);

        c.setTimeZone(TimeZone.getTimeZone(timeZone));
        String mMonthName = monthNames[c.get(Calendar.MONTH)];
        String mDayName = "";
        int mDay = c.get(Calendar.DAY_OF_MONTH);
        mDayName = Integer.toString(mDay);

        String mWeekDayName = weekDayNames[c.get(Calendar.DAY_OF_WEEK) - 1];

        return mMonthName + mDayName + "\t" + mWeekDayName;
    }

    /**
     * 获取IP
     */
    public static String localipget() {
        try {
            for (Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces(); en.hasMoreElements(); ) {
                NetworkInterface intf = en.nextElement();
                for (Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses(); enumIpAddr.hasMoreElements(); ) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (!inetAddress.isLoopbackAddress() && !inetAddress.isLinkLocalAddress()) {
                        return inetAddress.getHostAddress().toString();
                    }
                }
            }
        } catch (SocketException e) {
        }
        return null;
    }

    /**
     * 根据apk路径获取包名
     *
     * @param strFile apk路径
     * @return apk包名
     */
    public static String getPackageName(Context context, String strFile) {
        PackageManager pm = context.getPackageManager();
        PackageInfo packageInfo = pm.getPackageArchiveInfo(strFile, PackageManager.GET_ACTIVITIES);
        String mPackageName = null;
        if (packageInfo != null) {
            ApplicationInfo applicationInfo = packageInfo.applicationInfo;
            mPackageName = applicationInfo.packageName;
        }
        return mPackageName;
    }

    /**
     * 根据包名获取apk名称
     *
     * @param packageName 包名
     * @return apk名称
     */
    public static String getApkName(Context context, String packageName) {
        String apkName = null;
        PackageManager pm = context.getPackageManager();
        try {
            PackageInfo packageInfo = pm.getPackageInfo(packageName, PackageManager.GET_ACTIVITIES);
            if (packageInfo != null) {
                ApplicationInfo applicationInfo = packageInfo.applicationInfo;
                apkName = pm.getApplicationLabel(applicationInfo).toString();
                // int lable = applicationInfo.labelRes;
                // apkName = context.getResources().getString(lable);
            }
        } catch (NameNotFoundException e) {
            e.printStackTrace();
        }

        return apkName;
    }

    /**
     * 根据apk文件获取app应用名称
     *
     * @param apkFilePath apk文件路径
     */
    public static String getAppNameByApkFile(Context context, String apkFilePath) {
        String apkName = null;
        PackageManager pm = context.getPackageManager();
        PackageInfo packageInfo = pm.getPackageArchiveInfo(apkFilePath, PackageManager.GET_ACTIVITIES);
        if (packageInfo != null) {
            apkName = pm.getApplicationLabel(packageInfo.applicationInfo).toString();
        }
        return apkName;
    }


    public static boolean isConnectingToInternet(Context context) {
//        ConnectivityManager connectivity = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
//        if (connectivity != null) {
//            @SuppressWarnings("deprecation")
//            NetworkInfo[] info = connectivity.getAllNetworkInfo();
//            //use getAllNetworks() instead
//            if (info != null)
//                for (NetworkInfo anInfo : info) {
//                    if (anInfo.getState() == NetworkInfo.State.CONNECTED) {
//                        return true;
//                    }
//                }
//        }
        return false;
    }

    public static void closeAlertDialog(AlertDialog dialog, boolean flag) {
        try {
            Field field = dialog.getClass().getSuperclass().getDeclaredField("mShowing");
            field.setAccessible(true);
            field.set(dialog, flag);


        } catch (Exception e) {
            e.printStackTrace();
        }
    }

//    /**
//     * string 或者 list dialog
//     *
//     * @param mTitle            标题
//     * @param showDivider       分割线
//     * @param baseAdapter       adapter
//     * @param itemClickListener list点击事件
//     */
//    public static FullScreenListDialog showListDialog(Context context, String mTitle, boolean showDivider, BaseAdapter baseAdapter, AdapterView.OnItemClickListener itemClickListener) {
//        return showListDialog(context, mTitle, false, showDivider, baseAdapter, itemClickListener);
//    }


//    /**
//     * string 或者 list dialog
//     *
//     * @param mTitle            标题
//     * @param showDivider       分割线
//     * @param baseAdapter       adapter
//     * @param itemClickListener list点击事件
//     */
//    public static FullScreenListDialog showListDialog(Context context, String mTitle, boolean showFeedBack, boolean showDivider, BaseAdapter baseAdapter, AdapterView.OnItemClickListener itemClickListener) {
//        FullScreenListDialog dialog;
//        if (baseAdapter == null || baseAdapter.getCount() == 0) {
//            dialog = new FullScreenListDialog.Builder(context, null)
//                    .setDialogTitle(mTitle)
//                    .setListListener(itemClickListener)
//                    .setDividerEnable(showDivider)
//                    .setShowFeedback(showFeedBack)
//                    .create();
//        } else {
//            dialog = new FullScreenListDialog.Builder(context, baseAdapter)
//                    .setDialogTitle(mTitle)
//                    .setDividerEnable(showDivider)
//                    .setShowFeedback(showFeedBack)
//                    .setListListener(itemClickListener)
//                    .create();
//        }
//        dialog.show();
//        return dialog;
//    }

//    public static FullScreenListDialog showFeedbackDialog(Context context, String mTitle, boolean showDivider, BaseAdapter baseAdapter, AdapterView.OnItemClickListener itemClickListener, boolean showChecked, View.OnClickListener checkBoxListener, View.OnClickListener btnListener) {
//        FullScreenListDialog dialog;
//        if (baseAdapter == null || baseAdapter.getCount() == 0) {
//            dialog = new FullScreenListDialog.Builder(context, null)
//                    .setDialogTitle(mTitle)
//                    .setListListener(itemClickListener)
//                    .setDividerEnable(showDivider)
//                    .setShowFeedback(false)
//                    .create();
//        } else {
//            dialog = new FullScreenListDialog.Builder(context, baseAdapter)
//                    .setDialogTitle(mTitle)
//                    .setDividerEnable(showDivider)
//                    .setListListener(itemClickListener)
//                    .setShowFeedback(showChecked)
//                    .setCheckedListener(checkBoxListener)
//                    .setButtonClickListener(btnListener)
//                    .create();
//        }
//        dialog.show();
//        return dialog;
//    }

    public static String pathAsFileName(String path) {
        if (path == null)
            return null;

        return Utils.makeMD5(path);
    }

    /**
     * 设置布局的的背景图片
     */
    public static void setBackground(final Context context, final ViewGroup v) {
        setBackground(context, v, Constant.BACKGROUND_NAME);
    }

    public static void setBackground(final Context context, final ViewGroup v, final String backgroundName) {
        if (v == null || TextUtils.isEmpty(backgroundName)) {
            return;
        }
        Bitmap bmp = LruCacheUtils.getInstance().getBitmapFromMemCache(backgroundName);
        if (bmp == null) {
            //简单判断一下是asset下的图片
            AsyncUtils.doAsync(new UICallback<BitmapDrawable>() {
                @Override
                public void onUICompleted(BitmapDrawable result) {
                    if (result == null) {
                        return;
                    } else {
                        v.setBackground(result);
                    }
                }

                @Override
                public void onUIError(Throwable error) {
                }
            }, new ActionDelegate<BitmapDrawable>() {
                @Override
                public BitmapDrawable invoke() {
                    Bitmap bmp = null;
                    if (backgroundName.contains("/")) {
                        try {
                            FileInputStream fip = new FileInputStream(new File(backgroundName));
                            bmp = BitmapFactory.decodeStream(fip);
                            LruCacheUtils.getInstance().addBitmapToMemoryCache(backgroundName, bmp);
                        } catch (FileNotFoundException e) {
                            Log.e(TAG, "setBackground file not found");
                        }
                    } else {
                        //获得名称对应的的ID
                        Class clazz = R.drawable.class;
                        try {
                            int resId = clazz.getDeclaredField(backgroundName).getInt(null);
                            bmp = BitmapFactory.decodeResource(context.getResources(), resId);
                            if (BuildConfig.DEBUG) {
                                if (!bmp.isMutable()) {
                                    bmp = bmp.copy(Bitmap.Config.ARGB_8888, true);
                                }
                                float scale = context.getResources().getDisplayMetrics().density;
                                Canvas canvas = new Canvas(bmp);
                                Paint paint = new Paint();
                                paint.setColor(Color.rgb(255, 0, 0));
                                paint.setTextSize((int) (12 * scale)); // text size in pixels
                                paint.setShadowLayer(1f, 0f, 1f, Color.DKGRAY); // text shadow
                                canvas.drawText("DEBUG", bmp.getWidth() / 2, 12 * scale, paint);
                            }
                            LruCacheUtils.getInstance().addBitmapToMemoryCache(backgroundName, bmp);
                        } catch (IllegalAccessException e) {
                            Log.e(TAG, "setBackground find resId error:" + e.getMessage());
                        } catch (NoSuchFieldException e) {
                            Log.e(TAG, "setBackground find resId error:" + e.getMessage());
                        } catch (Exception e) {
                            Log.e(TAG, "setBackground find resId error:" + e.getMessage());
                        }
                    }
                    if (bmp == null) {
                        Log.e(TAG, "setBackground can not find the specified image");
                        return null;
                    }
                    return new BitmapDrawable(context.getResources(), bmp);
                }
            });
        } else {
            v.setBackground(new BitmapDrawable(context.getResources(), bmp));
        }

    }

    public static String getCaller() {
        StackTraceElement[] stackElements = Thread.currentThread().getStackTrace();
        if (stackElements == null)
            return "";

        String thisClsName = Utils.class.getName();

        int i = 0;
        while (i < stackElements.length && !thisClsName.equals(stackElements[i].getClassName()))
            i++;

        i += 2;
        if (i < stackElements.length) {
            StackTraceElement callerElement = stackElements[i];
            return callerElement.getClassName() +
                    "." +
                    callerElement.getMethodName() +
                    "()@" +
                    callerElement.getFileName() +
                    "(" +
                    callerElement.getLineNumber() +
                    ")";
        } else {
            return "";
        }
    }

    public static boolean isTheSameCaller(String newCaller, String oldCaller) {
        if (newCaller == null)
            return false;
        if (oldCaller == null)
            return false;

        String newClzName = newCaller.substring(0, newCaller.substring(0, newCaller.indexOf("()@")).lastIndexOf("."));
        String oldClzName = oldCaller.substring(0, oldCaller.substring(0, oldCaller.indexOf("()@")).lastIndexOf("."));

        return newClzName.equals(oldClzName);
    }

    public static int calPages(int items, int pageSize) {
        if (pageSize == 0)
            return 0;

        return items / pageSize + (items % pageSize == 0 ? 0 : 1);
    }

    private static long start = 0;

    private final static String DEF_ZH_PATTERN = "[\u4e00-\u9fa5]+";
    /**
     * @brief 对话框。
     */
    private static LiveLoadingDialog Loadingdialog = null;

    /**
     * 加载对话框。
     */
    private static LoadingDialog lDialog = null;

    /**
     * @brief TAG
     */
    private static final String TAG = "Utils";


    private static String mtext = "";

    private static Toast toast;

    public static View getRootView(Activity context) {
        return ((ViewGroup) context.findViewById(android.R.id.content)).getChildAt(0);
    }

    public static int getDimension(Context context, int id) {
        return (int) context.getResources().getDimension(id);
    }

    public static int getDimension(int id) {
        return (int) GlobalCloudManager.getInstance().getCallback().getApplication().getResources().getDimension(id);
    }

    public static int getDimensionPx(int id) {
        return GlobalCloudManager.getInstance().getCallback().getApplication().getResources().getDimensionPixelSize(id);
    }

    public static Locale getLocale(Context context) {
        return context.getResources().getConfiguration().locale;
    }

    public static void changeLanguage(String lang) throws RemoteException {
//        //本次直接打开系统的设置界面
//        IActivityManager iActMag = ActivityManagerNative.getDefault();
//        Configuration config = iActMag.getConfiguration();
//        config.locale = LocationHelper.createLocaleFromString(lang);
//        // 此处需要声明权限:android.permission.CHANGE_CONFIGURATION，如果没有这个权限会报JNI异常，app直接退出
//        // 会重新调用 onCreate();
//        iActMag.updateConfiguration(config);
    }

    public static boolean hasRoot() {
        return -1 != execRootCmdSilent("echo test");
    }

    public static int execRootCmdSilent(String cmd) {
        int result = -1;
        DataOutputStream dos = null;

        try {
            Process p = Runtime.getRuntime().exec("su");
            dos = new DataOutputStream(p.getOutputStream());

            Log.i(TAG, cmd);
            dos.writeBytes(cmd + "\n");
            dos.flush();
            dos.writeBytes("exit\n");
            dos.flush();
            p.waitFor();
            result = p.exitValue();
        } catch (Exception e) {
            throw new RuntimeException("No root right");
        } finally {
            if (dos != null) {
                try {
                    dos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static String versionCode2String(long versionCode) {
        if (versionCode <= 0) return "0.0.0";
        String tmp = "";
        String intVerStr = String.valueOf(versionCode);
        // >=10803 之后的逻辑
        if (intVerStr.length() < 8) {
            tmp = StringUtils.leftPad(intVerStr, 8, '0');
        } else {
            tmp = StringUtils.right(intVerStr, 8);
        }

        int majorVerNo = Integer.valueOf(tmp.substring(0, 2));
        int minorVerNo = Integer.valueOf(tmp.substring(2, 4));
        int revisionNo = Integer.valueOf(tmp.substring(4, 6));
        int buildNo = Integer.valueOf(tmp.substring(6, 8));

        String normalStr = majorVerNo + "." + minorVerNo + "." + revisionNo;
        String betaStr = "";
        if (buildNo < 66) {
            betaStr = "beta" + buildNo;
        }
        return normalStr + betaStr;
    }

    /*
"IMEI":"108124341597710"
"Model":"M86"
"SystemVersion":"4.4.2 4421005"
"EthernetMAC":"ec:22:57:00:00:28"
"WiFiMAC":"38:1d:d9:ce:da:8f"
"CPUInfo":"Processor	: ARMv7 Processor rev 1 (v7l)
processor	: 0
BogoMIPS	: 6.12

processor	: 1
BogoMIPS	: 2.00

processor	: 2
BogoMIPS	: 6.12

Features	: swp half thumb fastmult vfp edsp neon vfpv3 tls vfpv4
CPU implementer	: 0x41
CPU architecture: 7
CPU variant	: 0x0
CPU part	: 0xc05
CPU revision	: 1

Hardware	: Amlogic Meson8B
Revision	: 000a
Serial		: 1b00000000000000"
 */
    public static String getDeviceInfo() {
        String imeiVal = StringUtils.trimToEmpty(HardwareInfo.getInstance().getImei());
//        String modelNumVal = StringUtils.trimToEmpty(SystemInfoManager.getModelNumber());
//        String systemVersionVal = StringUtils.trimToEmpty(EnvHelper.getSystemVersion());
        String ethernetMac = StringUtils.trimToEmpty(HardwareInfo.getInstance().getEthernetMac());
        String wifiMac = StringUtils.trimToEmpty(HardwareInfo.getInstance().getWifiMac());
        Map<String, Object> deviceInfos = new HashMap<>();
        deviceInfos.put("IMEI", imeiVal);
//        deviceInfos.put("Model", modelNumVal);
//        deviceInfos.put("SystemVersion", systemVersionVal);
        deviceInfos.put("EthernetMAC", ethernetMac);
        deviceInfos.put("WiFiMAC", wifiMac);

        File file = new File("/proc/cpuinfo");
        if (file.exists()) {
            try {
                FileInputStream fis = new FileInputStream(file);
                String cpuInfo = IOUtils.toString(fis);
                IOUtils.closeQuietly(fis);
                Timber.d("cpuInfo:%s", cpuInfo);
                LineNumberReader reader = new LineNumberReader(new StringReader(cpuInfo));
                String line;
                Map<String, Object> map = new HashMap<>();
                while ((line = reader.readLine()) != null) {
                    String array[] = line.split(":");
                    if (array.length == 2) {
                        String key = StringUtils.trimToEmpty(array[0]);
                        String value = StringUtils.trimToEmpty(array[1]);
                        if ("processor".equalsIgnoreCase(key) && StringUtils.isNumeric(value)) {
                            Map<String, String> processor = new HashMap<>();
                            processor.put(key, value);
                            List processors;
                            Object object = map.get("processors");
                            if (object != null && object instanceof List) {
                                processors = (List) object;
                            } else {
                                processors = new ArrayList<>();
                                map.put("processors", processors);
                            }

                            while (true) {
                                String processorDetail = reader.readLine();
                                if (StringUtils.isEmpty(processorDetail))
                                    break;
                                String details[] = processorDetail.split(":");
                                if (details.length == 2) {
                                    processor.put(StringUtils.trimToEmpty(details[0]), StringUtils.trimToEmpty(details[1]));
                                }
                            }

                            processors.add(processor);
                        } else {
                            map.put(key, value);
                        }
                    }
                }

                deviceInfos.put("CPUInfo", map);
            } catch (Exception e) {
                TimberUtils.e(e, "get cpuInfo failed");
            }
        }

        String json = GsonUtil.getGson().toJson(deviceInfos);
        return json;
    }

    public static String nvl(String value, String defaultValue) {
        if (value == null) return defaultValue;
        return value;
    }

//    public static boolean isUat() {
//        return TextUtils.equals("uat", BuildConfig.FLAVOR_environment);
//    }
//
//    public static boolean isDev() {
//        return TextUtils.equals("dev", BuildConfig.FLAVOR_environment);
//    }
//
//    public static boolean isProd() {
//        return TextUtils.equals("prod", BuildConfig.FLAVOR_environment);
//    }

    public static String getJsonFromAssets(String fileName, Context context) {
        //将json数据变成字符串
        StringBuilder stringBuilder = new StringBuilder();

        BufferedReader bf = null;
        InputStreamReader is = null;
        try {
            is = new InputStreamReader(context.getAssets().open(fileName));
            bf = new BufferedReader(is);

            String line;
            while ((line = bf.readLine()) != null) {
                stringBuilder.append(line);
            }
        } catch (IOException e) {
            TimberUtils.e(e, "Error in getAssetData");
        } finally {
            try {
                is.close();
                bf.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return stringBuilder.toString();
    }

    //正则表达式
    public static boolean checkEmaile(String emaile) {
        /**
         *   ^匹配输入字符串的开始位置
         *   $结束的位置
         *   \转义字符 eg:\. 匹配一个. 字符  不是任意字符 ，转义之后让他失去原有的功能
         *   \t制表符
         *   \n换行符
         *   \\w匹配字符串  eg:\w不能匹配 因为转义了
         *   \w匹配包括字母数字下划线的任何单词字符
         *   \s包括空格制表符换行符
         *   *匹配前面的子表达式任意次
         *   .小数点可以匹配任意字符
         *   +表达式至少出现一次
         *   ?表达式0次或者1次
         *   {10}重复10次
         *   {1,3}至少1-3次
         *   {0,5}最多5次
         *   {0,}至少0次 不出现或者出现任意次都可以 可以用*号代替
         *   {1,}至少1次  一般用+来代替
         *   []自定义集合     eg:[abcd]  abcd集合里任意字符
         *   [^abc]取非 除abc以外的任意字符
         *   |  将两个匹配条件进行逻辑“或”（Or）运算
         *   [1-9] 1到9 省略123456789
         *    邮箱匹配 eg: ^[a-zA-Z_]{1,}[0-9]{0,}@(([a-zA-z0-9]-*){1,}\.){1,3}[a-zA-z\-]{1,}$
         *
         */
        String RULE_EMAIL = "^\\w+((-\\w+)|(\\.\\w+))*\\@[A-Za-z0-9]+((\\.|-)[A-Za-z0-9]+)*\\.[A-Za-z0-9]+$";
        //正则表达式的模式 编译正则表达式
        Pattern p = Pattern.compile(RULE_EMAIL);
        //正则表达式的匹配器
        Matcher m = p.matcher(emaile);
        //进行正则匹配\
        return m.matches();
    }

    public static boolean isMainThread() {
        return Looper.getMainLooper().getThread().getId() == Thread.currentThread().getId();
    }

    public static long string2Long(String str, long defValue) {
        try {
            return Long.valueOf(str);

        } catch (Exception e) {
            return defValue;
        }
    }


}
