package com.mm.c.cloud.interceptor;

import android.text.TextUtils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mm.c.cloud.help.RetrofitHelper;
import com.mm.c.cloud.lib.device.HardwareInfo;
import com.mm.c.cloud.lib.logger.TimberUtils;
import com.mm.c.cloud.lib.misc.utils.MiscUtils;
import com.mm.c.cloud.lib.misc.AppContextUtils;
import com.mm.c.cloud.manager.GlobalCloudManager;
import com.squareup.okhttp.FormEncodingBuilder;
import com.squareup.okhttp.RequestBody;

import org.apache.commons.lang3.StringUtils;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import com.squareup.okhttp.HttpUrl;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;

import timber.log.Timber;

/**
 * Created by elegant.wang on 2017/5/19.
 */
//该拦截器 负责 加解密 请求体和响应体
public class ApiCipherInterceptor implements Interceptor {
    private Gson gson;
    private java.lang.reflect.Type type;
    private String apiKey;
    private String mac;
    private int ver;

    private static final String KEY_CRYPT_VERSION = "5";

    public ApiCipherInterceptor() {
        gson = new GsonBuilder().serializeNulls()
                .setDateFormat("yyyy-MM-dd HH:mm:ss").create();
        type = new TypeToken<Map<String, String>>() {
        }.getType();
        apiKey = GlobalCloudManager.getInstance().getCallback().getApiServerKey2();
        mac = HardwareInfo.getInstance().getUserMac();
        ver = MiscUtils.getVersionCode(AppContextUtils.getContext());
    }

    @Override
    public Response intercept(Chain chain) throws IOException {
        Request request = chain.request();
        Request newRequest = null;
        boolean reqEncrypted = false; // 请求是否加密
        //boolean resEncrypted; // 响应是否加密
        boolean originalPost = false;

        ApiMetricCollector.ApiMetric apiMetric = new ApiMetricCollector.ApiMetric();
        apiMetric.mac = mac;
        apiMetric.ver = ver;
        apiMetric.requestId = System.currentTimeMillis();
        apiMetric.requestUrl = request.httpUrl().encodedPath();
        try {
            if (TextUtils.equals(request.method(), "POST") || !isCipherRequest(request)) { // post暂时不加密
                //return chain.proceed(request);
                reqEncrypted = false;
                newRequest = request;
                originalPost = true;
            } else {
                reqEncrypted = true;
                //String requestPath = request.httpUrl().encodedPath();
                apiMetric.requestEncryptBegin = System.currentTimeMillis();
                newRequest = getCipherRequest(request, "POST");
                apiMetric.requestEncryptEnd = System.currentTimeMillis();
            }
            Timber.e("Method[%s], Encrypted[%s], url[%s], [%s]", newRequest.method(), reqEncrypted, newRequest.url().toString(), newRequest.toString());
            apiMetric.reqEncrypted = reqEncrypted;
            // 返回
            apiMetric.networkBegin = System.currentTimeMillis();
            apiMetric.networkEnd = System.currentTimeMillis();

            Response response = chain.proceed(newRequest);
            if (!isCipherResponse(request)) {
                apiMetric.success = true;
                return response;
            }

            ResponseBody responseBody = response.body();
            apiMetric.responseSize = responseBody.contentLength();
            Response newResponse = null;
            try {
                //响应状态码 200~300 || 555  ----> 对响应体解密
                if (response.isSuccessful() || response.code() == 555) {
                    apiMetric.success = true;
                    if (originalPost) { // post请求的返回
                        newResponse = response;
                    } else {
                        String resStr = responseBody.string();
                        //Timber.i("TEST_CLOUD:url[%s], response[%s]",request.httpUrl(), resStr);
                        if (apiMetric.responseSize == -1) apiMetric.responseSize = resStr.length();

                        try {
                            Map<String, String> resData = gson.fromJson(resStr, type);
                            String resM;
                            if (!TextUtils.equals(resData.get("v"), "0")) { // 响应加密
                                apiMetric.resEncrypted = true;
                                apiMetric.responseDecryptBegin = System.currentTimeMillis();
                                resM = GlobalCloudManager.getInstance().getCallback().decryptString(resData.get("m"));
                                apiMetric.responseDecryptEnd = System.currentTimeMillis();
                            } else { // 响应未加密
                                apiMetric.resEncrypted = false;
                                resM = resData.get("m"); // 响应未加密
                            }
                            Timber.e("retM[%s,%s]", responseBody.contentType(), resM);
                            RetrofitHelper.checkBeenRemoved(resM);

                            ResponseBody newResponseBody = ResponseBody.create(responseBody.contentType(), resM);
                            newResponse = response.newBuilder().body(newResponseBody).build();
                        } catch (Throwable e) {
                            TimberUtils.e("parse json failed, just return original text[%s]", responseBody.contentType().toString());
                            ResponseBody newResponseBody = ResponseBody.create(responseBody.contentType(), resStr);
                            newResponse = response.newBuilder().body(newResponseBody).build();
                        }
                    }
                } else { // 不成功
                    apiMetric.success = false;
                    newResponse = response;
                }
            } catch (Exception e) {
                TimberUtils.e(e, "parse api response error!");
                newResponse = response;
            }
            return newResponse;
        } catch (IOException e) {
            TimberUtils.e(e, "fail in intercept");
            throw e;
        } finally {
            apiMetric.requestEnd = System.currentTimeMillis();
            ApiMetricCollector.getInstance().onAll(apiMetric);
        }
    }

    private boolean isCipherRequest(Request request) {
        String requestPath = request.httpUrl().encodedPath();
        return !(StringUtils.contains(requestPath, "/api/st/adjust/v1") ||
                StringUtils.contains(requestPath, "/api/st/afferent/v1"));
    }

    private boolean isCipherResponse(Request request) {
        String requestPath = request.httpUrl().encodedPath();
        return !StringUtils.contains(requestPath, "/api/st/get/v2");
    }

    private Request getCipherRequest(Request request, String method) {
        HttpUrl httpUrl = request.httpUrl();
        Map<String, String> params = new HashMap<>(20);
        for (int i = 0; i < httpUrl.querySize(); i++) {
            params.put(httpUrl.queryParameterName(i), httpUrl.queryParameterValue(i));
        }

//        if (!params.containsKey("st")) {
//            params.put("st", ARouter.getInstance().navigation(IAccountSerivce.class).getAccountInfo().getST());
//        }

        // suffix common params
        HashMap<String, String> otherParams = RequestParams.getCommonParams();
        if (request.url().toString().contains("/api/st/")) {
            otherParams.remove("language");
        }
        params.putAll(otherParams);

        String reqM = null;
        String reqS = null;
        try {
            reqM = GlobalCloudManager.getInstance().getCallback().encryptString(gson.toJson(params));
            reqS = GlobalCloudManager.getInstance().getCallback().sign(reqM);
        } catch (Exception e) {
            TimberUtils.e("encrypt api request error");
            reqM = "";
            reqS = "";
        }

        String newUrl = new StringBuilder().append(httpUrl.scheme()).append("://").append(httpUrl.host()).append(":").append(httpUrl.port()).append(httpUrl.encodedPath()).toString();
        Request newRequest;
        if (TextUtils.equals(method, "POST")) {
            RequestBody requestBody = new FormEncodingBuilder()
                    .add("v", KEY_CRYPT_VERSION)
                    .add("m", reqM)
                    .add("s", reqS)
                    .build();
            newRequest = request.newBuilder().url(newUrl).post(requestBody).build();
        } else {
            HttpUrl newHttpUrl = httpUrl.newBuilder()
                    .query("adddummy=")
                    .addQueryParameter("v", KEY_CRYPT_VERSION)
                    .addQueryParameter("m", reqM)
                    .addQueryParameter("s", reqS)
                    .build();
            newRequest = request.newBuilder().url(newHttpUrl).build();
        }
        return newRequest;
    }
}
