//package com.mm.c.cloud.interceptor;
//
//import com.mm.c.cloud.lib.api.utils.KeepClassMember;
//import com.valor.mfc.vms.api.model.charge.RCRechargeResp;
//
//import java.lang.reflect.Modifier;
//import java.util.ArrayList;
//import java.util.List;
//
//import static com.valor.mfc.vms.api.model.constant.response.HttpCode2.ERR_BIZ_INVALID_SERVICE_TOKEN;
//import static com.valor.mfc.vms.api.model.constant.response.HttpCode2.ERR_USER_INVALID;
//import static com.valor.mfc.vms.api.model.constant.response.HttpCode2.RET_INVALID_USER;
//import static com.valor.mfc.vms.api.model.constant.response.HttpCode2.SYS_CODE_ACCOUNT;
//import static com.valor.mfc.vms.api.model.constant.response.HttpCode2.SYS_CODE_AUTH;
//
///**
// * Auth模块的错误码
// */
//public class AuthExceptions {
//    private static List<AuthException> mExceptions;
//
//    static {
//        //添加Auth异常
//        try {
//            mExceptions = new ArrayList<>();
//            Class[] classes = AuthExceptions.class.getDeclaredClasses();
//            for (Class clz : classes) {
//                if (Modifier.isFinal(clz.getModifiers()))  // 异常实现类型 需要是Final类型
//                    mExceptions.add((AuthException) clz.newInstance());
//            }
//        } catch (Throwable e) {
//        }
//    }
//
//    public static AuthException match(int retcode, int num) {
//        if (num == 0) return null;
//        for (AuthException exception : mExceptions) {
//            if (exception.match(retcode, num)) {
//                return exception.mutable();
//            }
//        }
//        return null;
//    }
//
//    //Auth
//    private abstract static class AuthException extends Exception implements KeepClassMember {
//        //拷贝
//        AuthException mutable() {
//            try {
//                return getClass().getConstructor(new Class[0]).newInstance();
//            } catch (Exception e) {
//                e.printStackTrace();
//            }
//            return null;
//        }
//
//        abstract int errorNum();
//
//        abstract int groupNum();
//
//        final boolean match(int group, int num) {
//            return groupNum() == group && errorNum() == num;
//        }
//    }
//
//    //Auth-Recharge系列
//    public abstract static class RechargeException extends AuthException {
//        RCRechargeResp result;
//
//        public RCRechargeResp getResult() {
//            return result;
//        }
//
//        public void setResult(RCRechargeResp result) {
//            this.result = result;
//        }
//    }
//
//    public static final class UserAccountInvalid extends AuthException {
//        int groupNum() {
//            return RET_INVALID_USER;
//        }
//
//        int errorNum() {
//            return ERR_USER_INVALID;
//        }
//    } //后台用户校验不通过 非法用户
//
//    public static final class STValueInvalid extends AuthException {
//        int groupNum() {
//            return SYS_CODE_AUTH;
//        }
//
//        int errorNum() {
//            return ERR_BIZ_INVALID_SERVICE_TOKEN;
//        }
//    } //后台ST校验不通过
//
//    public static final class RechargeCodeInvalid extends RechargeException {
//        int groupNum() {
//            return SYS_CODE_AUTH;
//        }
//
//        int errorNum() {
//            return 20001;
//        }
//    } //使用充值卡失败
//
//    public static final class RechargeInNotAccount extends RechargeException {
//        int groupNum() {
//            return SYS_CODE_AUTH;
//        }
//
//        int errorNum() {
//            return 20002;
//        }
//    } //设备用户无法充值多设备套餐
//
//    public static final class RechargeNeedWait extends RechargeException {
//        int groupNum() {
//            return SYS_CODE_AUTH;
//        }
//
//        int errorNum() {
//            return 20003;
//        }
//    } //需要等到当前套餐过期后再进行充值
//
//    public static final class RechargeInAutoPay extends RechargeException {
//        int groupNum() {
//            return SYS_CODE_AUTH;
//        }
//
//        int errorNum() {
//            return 20004;
//        }
//    } //当前用户处于续费中，如果需要继续充值请确认
//
//    public static final class RechargeCauseUpgrade extends RechargeException {
//        int groupNum() {
//            return SYS_CODE_AUTH;
//        }
//
//        int errorNum() {
//            return 20005;
//        }
//    } //当前执行升级操作，如果要继续充值请确认
//
//    public static final class BindEmailInvaild extends AuthException {
//        int groupNum() {
//            return SYS_CODE_ACCOUNT;
//        }
//
//        int errorNum() {
//            return 20001;
//        }
//    } //邮箱账号不存在
//
//    public static final class BindEmailInactive extends AuthException {
//        int groupNum() {
//            return SYS_CODE_ACCOUNT;
//        }
//
//        int errorNum() {
//            return 20004;
//        }
//    } //邮箱账号未激活
//}
//
