package com.mm.c.cloud.interceptor;

import android.os.Build;

import com.mm.c.cloud.lib.api.UrlProvider;

import org.apache.commons.lang3.StringUtils;

import java.io.IOException;

import com.mm.c.cloud.lib.logger.TimberUtils;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;

public class MultiBaseUrlRetryInterceptor implements Interceptor {
    private UrlProvider provider;

    public MultiBaseUrlRetryInterceptor(UrlProvider provider) {
        this.provider = provider;
    }

    @Override
    public Response intercept(Chain chain) throws IOException {
        Request request = chain.request();
        final String originalUrl = request.url().toString();
        final Request.Builder newBuilder = request.newBuilder();

        //String originalHost;
        String requestPath;
        String nextUrl = originalUrl;
        try {
            int pos = originalUrl.indexOf("/", originalUrl.indexOf("://") + "://".length());
            //originalHost = originalUrl.substring(0, pos);
            requestPath = originalUrl.substring(pos);
        } catch (Exception e) {
            throw new IOException(e);
        }

        do {
            try {
                Response response = chain.proceed(request);
                return response;
            } catch (IOException e) {
                TimberUtils.e(e, "access host failed. try to get next host.");
                try {
                    nextUrl = provider.nextUrl(nextUrl);
                    if (!nextUrl.endsWith(requestPath)) {
                        nextUrl = nextUrl + requestPath;
                    }
                } catch (Exception ex) {
                    TimberUtils.e(ex, "get next host error:" + ex.getMessage());
                    throw new IOException(ex);
                }

                // no next url or next url is equal to originalUrl
                if (StringUtils.isEmpty(nextUrl)) {
                    TimberUtils.e("next host no found.");
                    throw e;
                }
                if (StringUtils.equals(nextUrl, originalUrl)) {
                    TimberUtils.e("next host is equal as original host, all hosts has been tried.");
                    throw e;
                }

                request = newBuilder.url(nextUrl).build();
            }
        } while (true);
    }
}
