package com.mm.c.cloud.interceptor;

import com.mm.c.cloud.BuildConfig;
import com.mm.c.cloud.lib.device.BuildInfo;
import com.mm.c.cloud.lib.device.HardwareInfo;
import com.mm.c.cloud.lib.misc.utils.MiscUtils;
import com.mm.c.cloud.manager.GlobalCloudManager;
import com.mm.c.cloud.lib.misc.AppContextUtils;

import java.util.HashMap;

public class RequestParams {

    private HashMap<String, String> map = new HashMap<>();

    private RequestParams() {
        map.put("firmware", BuildInfo.getInstance().getFirmware());
        map.put("host", BuildInfo.getInstance().getBuildHost());
        map.put("user", BuildInfo.getInstance().getBuildUser());
        map.put("device", BuildInfo.getInstance().getProductDevice());
        map.put("brand", BuildInfo.getInstance().getProductBrand());
        map.put("model", BuildInfo.getInstance().getProductModel());
        map.put("hardware", BuildInfo.getInstance().getHardware());
        map.put("systemVersion", BuildInfo.getInstance().getAndroidVersion());
        map.put("sdk", BuildInfo.getInstance().getSdk() + "");
        map.put("display", BuildInfo.getInstance().getBuildDisplay());
        map.put("fingerprint", BuildInfo.getInstance().getBuildFingerprint());
        map.put("manufacturer", BuildInfo.getInstance().getProductManufacturer());

        map.put("mac", HardwareInfo.getInstance().getUserMac());
        map.put("androidId", HardwareInfo.getInstance().getAndroidId());
        map.put("imeiId", HardwareInfo.getInstance().getImei());
        map.put("cpuId", HardwareInfo.getInstance().getCpuSerial());
        map.put("e_mac", HardwareInfo.getInstance().getEthernetMac());
        map.put("w_mac", HardwareInfo.getInstance().getWifiMac());
        map.put("b_mac", HardwareInfo.getInstance().getBluetoothMac());
        if (BuildConfig.DEBUG) {
            map.put("isDebug", "true");
        }
    }

    private static RequestParams INSTANCE;

    private void setVariableParmas() {
        map.put("language", MiscUtils.getLocaleString());
        map.put("launcherAppId", AppContextUtils.getLauncherAppId());
        map.put("region", GlobalCloudManager.getInstance().getCallback().getDetectedCountryCode());
        map.put("appVer", "" + MiscUtils.getVersionCode(AppContextUtils.getContext()));
        map.put("channel", MiscUtils.getReleaseType().toString());
    }

    public static final HashMap<String, String> getCommonParams() {
        if(null == INSTANCE) {
            INSTANCE = new RequestParams();
        }
        INSTANCE.setVariableParmas();
        return INSTANCE.map;
    }
}
