package com.mm.c.cloud.interceptor;

import com.mm.c.cloud.lib.device.HardwareInfo;
import com.mm.c.cloud.manager.GlobalCloudManager;
import com.mm.c.cloud.lib.misc.ntp.TrueTime;

import java.io.IOException;

import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;

//该拦截器负责 请求头加多一个cookie
public class SsoTokenInterceptor implements Interceptor {
    @Override
    public Response intercept(Chain chain) throws IOException {
        Request request = chain.request();
        String cookieValue = "did=" + getDid() + ";uid=" + getUid() + ";time=" + getTrueTime() + ";token=" + getToken();
        Request newRequest = request.newBuilder().addHeader("Cookie", cookieValue).build();
        return chain.proceed(newRequest);
    }

    private String getDid() {
        return HardwareInfo.getInstance().getUserMac();
    }

    private String getUid() {
        return String.valueOf(GlobalCloudManager.getInstance().getCallback().getUserId());
    }

    private String getToken() {
        return GlobalCloudManager.getInstance().getCallback().getToken();
    }

    private long getTrueTime() {
        return TrueTime.getInstance().currentTimeMillis();
    }
}
