package com.mm.c.cloud.lib.api;

import rx.Subscriber;

/**
 * 处理进度，用于长时间操作的用户信息反馈
 */
public class ProgressDataWrapper<T> {
    //进度，百分比
    private int progress = 0;
    private String message;
    private T data;
    private Subscriber mSubscriber;

    public ProgressDataWrapper(Subscriber subscriber) {
        if (subscriber != null) mSubscriber = subscriber;
    }

    public ProgressDataWrapper(boolean completed, int progress, String message) {
        this.progress = progress;
        this.message = message;
    }

    public ProgressDataWrapper(boolean completed, int progress, String message, T data) {
        this.progress = progress;
        this.message = message;
        this.data = data;
    }

    public ProgressDataWrapper<T> setProgress(int progress) {
        this.progress = progress;
        return this;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isCompleted() {
        return progress >= 100;
    }

    public int getProgress() {
        return progress;
    }

    public String getMessage() {
        return message;
    }

    public T getData() {
        return data;
    }

    public ProgressDataWrapper<T> setData(T data) {
        this.data = data;
        return this;
    }

    public void send() {
        if (mSubscriber != null) mSubscriber.onNext(this);
    }
}
