package com.mm.c.cloud.lib.api;

import com.mm.c.cloud.lib.logger.TimberUtils;
import com.valor.mfc.vms.api.model.common.response.ResponseStatus;
import com.valor.mfc.vms.api.model.constant.response.HttpCode2;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

import retrofit.ErrorHandler;
import retrofit.RetrofitError;
import retrofit.client.Header;
import retrofit.client.Response;
import retrofit.mime.TypedInput;

/**
 * Created by ASUS on 2016/7/6.
 */
public class RetrofitErrorHandler implements ErrorHandler {
    private static int[] authErrors = new int[]{HttpCode2.ERR_AUTH_INVALID_TOKEN, HttpCode2.ERR_AUTH_INVALID_DID, HttpCode2.ERR_AUTH_EXPIRED_TOKEN};

    /*
    *  状态码非
    * */
    @Override
    public Throwable handleError(RetrofitError retrofitError) {
        //555 错误只打印错误信息，其他记录堆栈信息
        //Timber.e("retrofitError:[%s]", retrofitError);
        if (retrofitError != null) {
            Response response = retrofitError.getResponse();
            if (response != null && retrofitError.getResponse().getStatus() == 555) {
                //555状态码 响应体已经被解密, 可成功转为业务响应体Bean: ResponseStatus
                ResponseStatus responseStatus = (ResponseStatus) retrofitError.getBodyAs(ResponseStatus.class);
                if (responseStatus != null) {
                    if (Arrays.binarySearch(authErrors, responseStatus.getErrCode()) >= 0) {
                        // 发生认证失败的错误尝试重新登陆
                        /*new Thread() {
                            @Override
                            public void run() {
                                try {
                                    UserManager.getInstance().loginBlock();
                                } catch (Exception e) {
                                    TimberUtils.e(e, "encounter auth error,but retry login with error");
                                }
                            }
                        }.start();*/
                    }
                    TimberUtils.e("server error 555: %s (%s-%s)", responseStatus.getMessage(), responseStatus.getRetCode(), responseStatus.getErrCode());
                } else
                    TimberUtils.e("server error 555: no server response");
            } else if (retrofitError.getCause() != null && retrofitError.getCause().getClass().getName().contains("com.mm.c.auth.AuthFlowError")){

            }else{
                String message;
                if (response != null) {
                    message = responseToString(response);
                } else {
                    message = String.format(Locale.ENGLISH, "RetrofitError:%s URL:[%s]", retrofitError.getMessage(), retrofitError.getUrl());
                }
                TimberUtils.e(retrofitError, message);
            }
        } else {
            TimberUtils.e("WTF:RetrofitError is null");
        }
        return retrofitError;
    }

    private String responseToString(Response response) {
        try {
            return String.format(Locale.ENGLISH,
                    "status=[%d], reason=[%s], headers[%s], body=[%s], url[%s]",
                    response.getStatus(),
                    response.getReason(),
                    headerToString(response.getHeaders()),
                    bodyToString(response.getBody()),
                    response.getUrl()
            );
        } catch (Throwable e) {
            TimberUtils.e(e, "response to String error.");
        }
        return "";
    }

    private String headerToString(List<Header> headers) {
        if (headers == null)
            return "null";

        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (Header header:headers) {
            builder.append(header);
        }
        builder.append("]");
        return builder.toString();
    }

    private String bodyToString(TypedInput body) {
        if (body == null)
            return "null";

        try {
            StringBuilder builder = new StringBuilder();
            builder.append("{mimi=\"").append(body.mimeType()).append("\",");
            builder.append("length=").append(body.length()).append(",");
            builder.append("body=\"");
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(body.in()));
                String line;
                while ((line = reader.readLine()) != null) {
                    builder.append(line).append("\n");
                }
            } catch (Exception e) {
                TimberUtils.e(e, "body to string error");
            } finally {
                builder.append("\"}");
            }
            return builder.toString();
        } catch (Exception e) {
            TimberUtils.e(e, "body to string error");
        }

        return "";
    }
}

