package com.mm.c.cloud.lib.api.ns.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NSResponse extends com.valor.mfc.vms.api.model.ns.NSResponse implements INSInfo {
    private Map<String, List<NSHost>> map;

    @Override
    public int getStatus() {
        return 0;
    }

    @Override
    public long getCurrentTime() {
        return super.getRequestTime();
    }

    @Override
    public Map<String, ? extends List<? extends IHostInfo>> getHostInfoMap() {
        if (map != null)
            return map;

        map = new HashMap<>();
        for (Map.Entry<String, List<com.valor.mfc.vms.api.model.ns.NSHost>> entry : super.getNs().entrySet()) {
            List<NSHost> list = new ArrayList<>();
            for (com.valor.mfc.vms.api.model.ns.NSHost host : entry.getValue()) {
                NSHost nsHost = new NSHost(host.getHost(), host.getPort());
                list.add(nsHost);
            }
            map.put(entry.getKey(), list);
        }

        return map;
    }

    @Override
    public long getCacheDurationMills() {
        return super.getCacheDuration();
    }
}
