package com.mm.c.cloud.lib.api.service;

import com.mm.c.cloud.CloudAccount;
import com.mm.c.cloud.lib.api.response.ResponseDataList;
import com.mm.c.cloud.lib.api.response.ResponseDataSingle;
import com.valor.mfc.vms.api.model.cloud.CloudAcctDo;
import com.valor.mfc.vms.api.model.cloud.ELoginType;
import com.valor.mfc.vms.api.model.common.response.ResponseStatus;

import java.util.Map;

import retrofit.http.GET;
import retrofit.http.Multipart;
import retrofit.http.POST;
import retrofit.http.Part;
import retrofit.http.Query;
import retrofit.http.QueryMap;
import retrofit.mime.TypedFile;
import rx.Observable;

public interface CloudRefreshServerApi {

    @GET("/api/cloud/queryList/v2")
    Observable<ResponseDataList<CloudAcctDo>> rxQueryList(
            @Query("token") String token,
            @Query("accountType") int accountType,
            @Query("accountId") long accountId,
            @Query("uid") String uid,
            @Query("site") String site,
            @Query("includeLogin") int includeLogin,
            @Query("appVer") int appVer,
            @Query("language") String language,
            @Query("region") String region
    );

    @GET("/api/cloud/queryList/v2")
    Observable<ResponseDataList<CloudAcctDo>> rxQueryList(
            @QueryMap Map<String, String> params
    );

    @GET("/api/cloud/refresh/v3")
    Observable<ResponseStatus> rxRequestCloudRefresh(
            @Query("token") String token,
            @Query("accountType") int accountType,
            @Query("accountId") long accountId,
            @Query("uid") String uid,
            @Query("cids") String cids,
            @Query("acct") String acct,
            @Query("appVer") int appVer,
            @Query("language") String language,
            @Query("region") String region
    );

    @GET("/api/cloud/delAllAcct/v1")
    Observable<ResponseStatus> rxCloudDelAll(
            @Query("token") String token,
            @Query("accountType") int accountType,
            @Query("accountId") long accountId,
            @Query("uid") String uid,
            @Query("appVer") int appVer,
            @Query("did") String did
    );

    @GET("/api/cloud/reg/v2")
    Observable<ResponseDataSingle<CloudAcctDo>> rxCloudReg(
            @Query("token") String token,
            @Query("accountType") int accountType,
            @Query("accountId") long accountId,
            @Query("uid") String uid,
            @Query("site") String site,
            @Query("acct") String acct,
            @Query("acctAlias") String alias,
            @Query("loginType") ELoginType loginType,
            @Query("loginId") String loginId,
            @Query("loginKey") String loginKey,
            @Query("appVer") int appVer,
            @Query("language") String language,
            @Query("region") String region
    );

    @GET("/api/cloud/refresh/v2")
    Observable<ResponseDataSingle<CloudAcctDo>> rxCloudRefresh(
            @Query("token") String token,
            @Query("accountType") int accountType,
            @Query("accountId") long accountId,
            @Query("uid") String uid,
            @Query("site") String site,
            @Query("cid") long cid,
            @Query("acct") String acct,
            @Query("appVer") int appVer,
            @Query("language") String language,
            @Query("region") String region
    );

    @GET("/api/cloud/queryList/v2")
    Observable<ResponseDataList<CloudAcctDo>> rxQueryListWithAcct(
            @Query("token") String token,
            @Query("accountType") int accountType,
            @Query("accountId") long accountId,
            @Query("uid") String uid,
            @Query("site") String site,
            @Query("cid") long cid,
            @Query("acct") String acct,
            @Query("includeLogin") int includeLogin,
            @Query("appVer") int appVer,
            @Query("language") String language,
            @Query("region") String region
    );

    @GET("/api/cloud/delacct/v2")
    Observable<ResponseStatus> rxCloudDel(
            @Query("token") String token,
            @Query("accountType") int accountType,
            @Query("accountId") long accountId,
            @Query("uid") String uid,
            @Query("site") String site,
            @Query("cid") long cid,
            @Query("acct") String acct,
            @Query("appVer") int appVer,
            @Query("language") String language,
            @Query("region") String region
    );

    @Multipart
    @POST("/api/cloud/importResPkg/v2")
    Observable<ResponseDataList<CloudAcctDo>> rxImportResPkg(
            @Part("resPkg") TypedFile resPkg,
            @Query("token") String token,
            @Query("accountType") int accountType,
            @Query("accountId") long accountId,
            @Query("actCode") String actCode,
            @Query("uid") String uid,
            @Query("appVer") int appVer,
            @Query("language") String language,
            @Query("region") String region
    );
}
