package com.mm.c.cloud.lib.api.service;

import com.google.gson.JsonObject;
import com.mm.c.cloud.lib.api.profile.model.HotKey;
import com.mm.c.cloud.lib.api.response.ResponseDataList;
import com.mm.c.cloud.lib.api.response.ResponseDataSingle;
import com.valor.mfc.vms.api.model.cloud.CloudPlaySourceDo;
import com.valor.mfc.vms.api.model.common.response.ResponseStatus;
import com.valor.mfc.vms.api.model.constant.EMetaSource;
import com.valor.mfc.vms.api.model.filter.FilterCriteriaDo;
import com.valor.mfc.vms.api.model.filter.FilterDo;
import com.valor.mfc.vms.api.model.linked.common.LinkedAcctDo;
import com.valor.mfc.vms.api.model.linked.request.LinkedCheckReq;
import com.valor.mfc.vms.api.model.linked.request.LinkedSyncReq;
import com.valor.mfc.vms.api.model.linked.request.LinkedSyncReqV2;
import com.valor.mfc.vms.api.model.linked.response.LinkedAcctMetaDo;
import com.valor.mfc.vms.api.model.linked.response.LinkedCheckRsp;
import com.valor.mfc.vms.api.model.linked.response.LinkedSyncStatusDo;
import com.valor.mfc.vms.api.model.meta.base.v1.BaseMetaDO;
import com.valor.mfc.vms.api.model.meta.media.v1.ArtworkDO;
import com.valor.mfc.vms.api.model.meta.media.v1.CastDO;
import com.valor.mfc.vms.api.model.meta.media.v1.MediaAwardDo;
import com.valor.mfc.vms.api.model.meta.media.v1.MediaMetaDo;
import com.valor.mfc.vms.api.model.meta.media.v1.ParentsGuideDo;
import com.valor.mfc.vms.api.model.meta.media.v1.SynopsisMetaDO;
import com.valor.mfc.vms.api.model.meta.media.v1.TrailerDO;
import com.valor.mfc.vms.api.model.meta.media.v1.UserReviewMetaDO;
import com.valor.mfc.vms.api.model.meta.media.v1.VideoMetaDO;
import com.valor.mfc.vms.api.model.meta.person.v1.PersonDetailMetaDO;
import com.valor.mfc.vms.api.model.meta.playlist.v1.PlaylistVideosDO;
import com.valor.mfc.vms.api.model.ui.UIConfigDo;

import java.util.Map;

import retrofit.Callback;
import retrofit.http.Body;
import retrofit.http.GET;
import retrofit.http.POST;
import retrofit.http.Query;
import retrofit.http.QueryMap;
import rx.Observable;

/**
 * Created by sunny on 2015/10/5.
 */
public interface MetaDataServerServiceAsync {

    @GET("/api/ui/cfg/v1")
    Observable<ResponseDataList<UIConfigDo>> getUICfg(
            @QueryMap Map<String, String> params);

    @GET("/api/playlist/videos/v1")
    Observable<ResponseDataSingle<PlaylistVideosDO>> getPlayListVideos(
            @QueryMap Map<String, String> params,
            @Query("playlistId") long playListID,
            @Query("appendResult") String appendResult);

    @GET("/api/playlist/videos/v1")
    void getPlayListVideos(
            @QueryMap Map<String, String> params,
            @Query("playlistId") long playListID,
            @Query("pageId") int pageId,
            @Query("pageSize") int pageSize,
            @Query("appendResult") String appendResult,
            Callback<ResponseDataSingle<PlaylistVideosDO>> callback);

    @GET("/api/playlist/videos/v1")
    void getPlayListVideos(
            @QueryMap Map<String, String> params,
            @Query("playlistId") long playListID,
            @Query("name") String name,
            @Query("pageId") int pageId,
            @Query("pageSize") int pageSize,
            @Query("linked") int linked,
            @Query("appendResult") String appendResult,
            Callback<ResponseDataSingle<PlaylistVideosDO>> callback);

    @GET("/api/playlist/videos/v1")
    Observable<ResponseDataSingle<PlaylistVideosDO>> getPlayListVideos(
            @QueryMap Map<String, String> params,
            @Query("playlistId") long playListID,
            @Query("name") String name,
            @Query("pageId") int pageId,
            @Query("pageSize") int pageSize,
            @Query("linked") int linked,
            @Query("appendResult") String appendResult);

    @GET("/api/person/detail/v1")
    void getPersonDetailMetaDO(
            @QueryMap Map<String, String> params,
            @Query("exPersonId") String exPersonId,
            @Query("personId") long personBaseID,
            @Query("pageSize") int pageSize,
            @Query("appendResult") String appendResult,
            Callback<ResponseDataSingle<PersonDetailMetaDO>> callback);

    @GET("/api/person/filmography/v1")
    void getPersonFilmographies(
            @QueryMap Map<String, String> params,
            @Query("personId") long personBaseID,
            @Query("pageId") int pageId,
            @Query("pageSize") int pageSize,
            @Query("appendResult") String appendResult,
            @Query("videoType") String videoType,
            @Query("released") int released,
            Callback<ResponseDataList<BaseMetaDO>> callback);

    @GET("/api/media/detail/v1")
    void getMovieInfoEx(
            @Query("appVer") int appVer,
            @Query("videoId") Long videoID,
            @Query("exMetaSource") EMetaSource exMetaSource,
            @Query("exMetaId") String exMetaID,
            @Query("region") String region,
            @Query("language") String language,
            @Query("excludeResult") String excludeResult,
            Callback<ResponseDataSingle<VideoMetaDO>> callback);

    @GET("/api/media/episode/v1")
    void getEpisodesInfoEx(
            @QueryMap Map<String, String> params,
            @Query("pageId") int pageId,
            @Query("pageSize") int pageSize,
            @Query("seriesId") long seriesId,
            @Query("seasonId") long seasonId,
            @Query("episodeOrder") String episodeOrder,
            @Query("appendResult") String appendResult,
            Callback<ResponseDataList<VideoMetaDO>> callback
    );

    /**
     * 同步link信息 post
     * /api/linked/sync/v1
     * post数据: LinkedSyncReq
     * 响应数据: ResponseStatus
     */
    @POST("/api/linked/sync/v1")
    Observable<ResponseDataSingle<LinkedAcctDo>> uploadLinkedRes(
            @QueryMap Map<String, String> params,
            @Body LinkedSyncReq req);

    /**
     * 同步link信息 v2
     * linkedSync 同步数据到Meta Server
     * linkedSyncState 查询同步状态
     */
    @POST("/api/linked/sync/v2")
    Observable<ResponseDataSingle<LinkedSyncStatusDo>> linkedSync(
            @Body LinkedSyncReqV2 req,
            @QueryMap Map<String, String> params
    );

    @GET("/api/linked/sync/status/v2")
    Observable<ResponseDataList<LinkedSyncStatusDo>> linkedSyncState(
            @Query("uid") String uid,
            @Query("batchNumber") long batchNumber,
            @Query("serialNumber") long serialNumber,
            @Query("appVer") int appVer,
            @Query("region") String region,
            @Query("language") String language
    );

    /**
     * 校验linked信息 post
     * /api/linked/check/v1
     * post数据: LinkedCheckReq
     * 响应数据: LinkedCheckRsp
     */
    @POST("/api/linked/check/v1")
    Observable<ResponseDataSingle<LinkedCheckRsp>> checkLinkedRes(
            @Query("appVer") int appVer,
            @Body LinkedCheckReq req,
            @Query("region") String region,
            @Query("language") String language);

    /**
     * /api/linked/query/v1?site=&acct=&detail
     * 参数:
     * site:站点
     * acct:账户
     * detail: 1:返回详细列表 0:不返回详细列表
     * 返回结构：
     * LinkedMetaList
     */
    @GET("/api/linked/query/v1")
    Observable<ResponseDataList<LinkedAcctMetaDo>> getLinkedRes(
            @QueryMap Map<String, String> params,
            @Query("site") String site,
            @Query("acct") String account,
            @Query("detail") int includeDetail);

    @GET("/api/linked/delacct/v1")
    Observable<ResponseStatus> removeLinkedAcct(
            @QueryMap Map<String, String> params,
            @Query("site") String site,
            @Query("acct") String account);


    @GET("/api/search/filter/criteria/v1")
    void getFilterCriteria(
            @QueryMap Map<String, String> params,
            @Query("pid") String playlistId,
            @Query("videoType") String videoType,
            Callback<ResponseDataSingle<FilterCriteriaDo>> callback);

    @GET("/api/search/filter/criteria/v2")
    void getFilterCriteria2(
            @QueryMap Map<String, String> params,
            @Query("pid") String playlistId,
            @Query("videoType") String videoType,
            Callback<ResponseDataList<FilterDo>> callback);

    /*Video相关api合并为一个
     *api/media/detail/v1        详情
     *api/media/similar/v1       相似影片
     * api/media/userreview/v1   用户评论
     * api/media/synopsis/v1     剧透
     * api/media/search/v1       搜索过滤
     */

    //详情
    @GET("/api/media/detail/v1")
    void getVideoDetail(
            @QueryMap Map<String, String> params,
            @Query("videoId") long videoID,
            @Query("exMetaSource") EMetaSource exMetaSource,
            @Query("exMetaId") String exMetaID,
            @Query("appendResult") String appendResult,
            @Query("excludeResult") String excludeResult,
            Callback<ResponseDataSingle<MediaMetaDo>> callback
    );

    //相似&推荐影片
    @GET("/api/media/similar/v1")
    void getRecommendVideo(
            @QueryMap Map<String, String> params,
            @Query("videoId") long videoID,
            @Query("exMetaSource") EMetaSource exMetaSource,
            @Query("exMetaId") String exMetaID,
            @Query("appendResult") String appendResult,
            Callback<ResponseDataList<BaseMetaDO>> callback
    );


    //获取奖项信息
    @GET("/api/media/awards/v1")
    void getCriticReviews(
            @QueryMap Map<String, String> params,
            @Query("videoId") long videoID,
            @Query("language") String language,
            Callback<ResponseDataList<MediaAwardDo>> callback
    );


    //用户评论
    @GET("/api/media/userreview/v1")
    void getVideoUserReviews(
            @QueryMap Map<String, String> params,
            @Query("videoId") long videoId,
            Callback<ResponseDataList<UserReviewMetaDO>> callback
    );

    //剧透
    @GET("/api/media/synopsis/v1")
    void getVideoSynopsis(
            @QueryMap Map<String, String> params,
            @Query("videoId") long videoId,
            Callback<ResponseDataSingle<SynopsisMetaDO>> callback
    );

    //搜索过滤
    @GET("/api/media/search/v1")
    void getVideoFilter(
            @QueryMap Map<String, String> params,
            @Query("videoType") String videoType,
            @Query("pid") String playlistId,
            @Query("filter") String filter,
            @Query("linked") int linked,
            @Query("pageId") int pageId,
            @Query("pageSize") int pageSize,
            @Query("appendResult") String appendResult,
            Callback<ResponseDataList<BaseMetaDO>> callback
    );

    @GET("/api/media/parentsGuide/v1")
    void queryParentGuide(
            @QueryMap Map<String, String> params,
            @Query("videoId") long videoID,
            @Query("exMetaId") String exMetaID,
            @Query("exMetaSource") EMetaSource exMetaSource,
            Callback<ResponseDataList<ParentsGuideDo>> callback
    );

    @GET("/api/media/trailer/v1")
    void queryTrailer(
            @QueryMap Map<String, String> params,
            @Query("videoId") long videoID,
            @Query("exMetaSource") EMetaSource exMetaSource,
            @Query("exMetaId") String exMetaID,
            Callback<ResponseDataList<TrailerDO>> callback
    );

    @GET("/api/media/cast/v1")
    void queryCast(
            @QueryMap Map<String, String> params,
            @Query("videoId") long videoID,
            @Query("exMetaSource") EMetaSource exMetaSource,
            @Query("exMetaId") String exMetaID,
            @Query("maxDirectors") int maxDirectors,
            @Query("maxStars") int maxStars,
            Callback<ResponseDataSingle<CastDO>> callback
    );

    @GET("/api/media/artwork/v1")
    void queryArtwork(
            @QueryMap Map<String, String> params,
            @Query("videoId") long videoID,
            @Query("exMetaSource") EMetaSource exMetaSource,
            @Query("exMetaId") String exMetaID,
            Callback<ResponseDataList<ArtworkDO>> callback
    );

    @GET("/api/media/baseInfo/v1")
    Observable<ResponseDataList<BaseMetaDO>> rxQueryBaseMetaByIds(
            @QueryMap Map<String, String> params,
            @Query("ids") String videIds,
            @Query("idType") int idType,
            @Query("appendResult") String appendResult
    );

    @GET("/api/media/baseInfo/v1")
    void getBaseMetaByIds(
            @QueryMap Map<String, String> params,
            @Query("ids") String videIds,
            @Query("idType") int idType,
            @Query("appendResult") String appendResult,
            Callback<ResponseDataList<BaseMetaDO>> callback
    );


    @GET("/api/ops/setSubStatus/v1")
    void reportSubtitlesSetting(
            @QueryMap Map<String, String> params,
            @Query("metaId") String metaId,
            @Query("subLanguage") String subLanguage,
            @Query("seasonId") Integer seasonId,
            @Query("episodeId") Integer episodeId,
            Callback<ResponseStatus> callback
    );

    @GET("/api/ops/querySubStatus/v1")
    Observable<JsonObject> getSubtitlesStatus(
            @QueryMap Map<String, String> params,
            @Query("metaId") String id,
            @Query("seasonId") Integer uid,
            @Query("episodeId") Integer did);

    @GET("/api/media/playSource/v1")
    Observable<ResponseDataList<CloudPlaySourceDo>> rxPlaySource(
            @Query("videoId") long videoId,
            @Query("season") int season,
            @Query("episode") int episode,
            @Query("displayMode") String displayMode,
            @Query("uid") String uid,
            @Query("appVer") int appVer,
            @Query("language") String language,
            @Query("region") String region
    );

    @GET("/api/media/playSource/v1")
    void getPlaySource(
            @QueryMap Map<String, String> params,
            @Query("videoId") long videoId,
            @Query("season") int season,
            @Query("episode") int episode,
            @Query("displayMode") String displayMode,
            @Query("st") String serviceToken,
            @Query("accountType") int accountType,
            @Query("accountId") long accountId,
            Callback<ResponseDataList<CloudPlaySourceDo>> callback
    );

    @GET("/api/search/hotKeyword/list")
    Observable<ResponseDataList<HotKey>> fetchHotKey(@QueryMap Map<String, String> params);
}
