package com.mm.c.cloud.lib.api.service;


import retrofit.client.Response;
import retrofit.http.GET;
import retrofit.http.Path;
import rx.Observable;

/**
 * MFC web server api
 */
public interface WebConfigServerAPI {

    @GET("/webconfig/stb/feedback/issues.json")
    Observable<Response> getFeedbackOptions();

    @GET("/webconfig/stb/qrcode/{lang}.html")
    Observable<Response> getQRCodeHtmlPage(
            @Path("lang") String lang);

    @GET("/webconfig/stb/playerpicker.json")
    Observable<Response> getPlayerPicker();

    @GET("/webconfig/eula/{lang}.html")
    Observable<Response> getCloudTerms(
            @Path("lang") String lang);

    @GET("/webconfig/string/{lang}.xml")
    Observable<Response> getI18n(@Path("lang") String lang);

    @GET("/webconfig/string/i18n.xml")
    Observable<Response> getDes_i18n();
}
