package com.mm.c.cloud.lib.common.asynctask;

import android.os.Looper;

public abstract class UICallback<T> implements CallbackTask<T> {
    public abstract void onUICompleted(T paramT);

    public abstract void onUIError(Throwable paramThrowable);

    public void onCompleted(final T result) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            onUICompleted(result);
        } else {
            AsyncUtils.runOnUiThread(new ActionDelegate() {
                public Void invoke() {
                    UICallback.this.onUICompleted(result);
                    return null;
                }
            });
        }
    }

    public void onError(final Throwable error) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            onUIError(error);
        } else {
            AsyncUtils.runOnUiThread(new ActionDelegate() {
                public Void invoke() {
                    UICallback.this.onUIError(error);
                    return null;
                }
            });
        }
    }
}