package com.mm.c.cloud.lib.common.preferences.provider;

import android.content.Context;
import android.util.Log;

import com.mm.c.cloud.lib.misc.crypto.AESCodecAndroid;

import net.grandcentrix.tray.provider.ContentProviderStorage;

/**
 * Created by elegant.wang on 2016/8/9.
 */
public class CipherContentProviderStorage extends ContentProviderStorage {
    private static final String TAG = CipherContentProviderStorage.class.getCanonicalName();
    private String cipherKey;

    public CipherContentProviderStorage(Context context, String module, Type type, String cipherKey) {
        super(context, module, type);
        this.cipherKey = cipherKey;
    }

    @Override
    public void put(String key, String migrationKey, Object data) {
        if (data == null) {
            super.put(key, migrationKey, null);
            return;
        }
        if (data instanceof String || data instanceof Integer || data instanceof Long || data instanceof Float || data instanceof Boolean || data instanceof Double) {
            String value = String.valueOf(data);
            String newValue;
            try {
                newValue = AESCodecAndroid.encrypt(value, cipherKey);
            } catch (Exception e) {
                Log.e(TAG, "put error,use original value");
                newValue = value;
            }
            super.put(key, migrationKey, newValue);
        } else {
            super.put(key, migrationKey, data);
        }
    }
}
