package com.mm.c.cloud.lib.dao;

import android.content.Context;
import android.content.res.AssetManager;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import android.util.Log;

import org.apache.commons.lang3.StringUtils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by Larry on 2016/6/12.
 */
public class DbUpgradeHelper {
    private final static String TAG = "DbUpgradeHelper";

    public static void executeManualUpgrade(Object db, Context ctx, int oldVersion, int newVersion) {
        Log.e(TAG, "Updating table from " + oldVersion + " to " + newVersion);
        try {
            String sqlFolder = "sql";
            String[] sqlFileNames = ctx.getAssets().list(sqlFolder);
            String accurateVersionSqlFileName = "requery_upgrade_" + oldVersion + "_to_" + newVersion + ".sql";
            if (Arrays.binarySearch(sqlFileNames, accurateVersionSqlFileName) >= 0) {
                String sqlFilePath = sqlFolder + File.separator + accurateVersionSqlFileName;
                Log.d(TAG, "Found accurate migration file: " + sqlFilePath);
                //execute
                readAndExecuteSQLScript(db, ctx, sqlFilePath);
            } else {
                List<String> selectedSqlFilePaths = parseSqlFilePaths(sqlFolder, sqlFileNames, oldVersion, newVersion);
                //execute
                for (String sqlPath : selectedSqlFilePaths) {
                    Log.d(TAG, "Found multiple levels migration file: " + sqlPath);
                    readAndExecuteSQLScript(db, ctx, sqlPath);
                }
            }
        } catch (Exception e) {
            Log.e(TAG, "Error in db upgrade", e);
        }
    }

    protected static List<String> parseSqlFilePaths(String folder, String[] sqlFileNames, int oldVersion, int newVersion) {

        TreeMap<Integer, String> treeMap = new TreeMap<>();
        for (String sqlFileName : sqlFileNames) {
            String versionPattern = "(?i)requery_upgrade_(.*)_to_(.*).sql";
            Matcher versionMatcher = Pattern.compile(versionPattern).matcher(sqlFileName);
            if (!versionMatcher.find()) {
                Log.e(TAG, "This is not a db upgrade version file: " + sqlFileName);
                continue;
            }
            String fromVersionStr = versionMatcher.group(1);
            String toVersionStr = versionMatcher.group(2);
            int sqlFromVersion = Integer.parseInt(fromVersionStr);
            int sqlToVersion = Integer.parseInt(toVersionStr);

            if (sqlFromVersion >= oldVersion && sqlToVersion <= newVersion) {
                String sqlFilePath = folder + File.separator + sqlFileName;
                Log.d(TAG, "Find migration file: " + sqlFilePath);
                treeMap.put(sqlFromVersion, sqlFilePath);
            }
        }
        List<String> selectedSqlFilePaths = new ArrayList<>(treeMap.values());
        return selectedSqlFilePaths;
    }

    private static void readAndExecuteSQLScript(Object db, Context ctx, String fileName) {
        if (TextUtils.isEmpty(fileName)) {
            Log.d(TAG, "SQL script file name is empty:" + fileName);
            return;
        }

        Log.d(TAG, "Script found. Executing..." + fileName);
        AssetManager assetManager = ctx.getAssets();
        BufferedReader reader = null;

        try {
            InputStream is = assetManager.open(fileName);
            InputStreamReader isr = new InputStreamReader(is);
            reader = new BufferedReader(isr);
            executeSQLScript(db, reader);
            Log.d(TAG, "Script executed..." + fileName);
        } catch (IOException e) {
            Log.e(TAG, "IOException:" + fileName, e);
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e) {
                    Log.e(TAG, "IOException:" + fileName, e);
                }
            }
        }

    }

    private static void executeSQLScript(Object db, BufferedReader reader) throws IOException {
        String line;
        StringBuilder statement = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("#")) {
                continue;
            }
            statement.append(line);
            statement.append("\n");
            if (line.endsWith(";")) {
                String statementVal = statement.toString();
                if (StringUtils.startsWith(statementVal, "java")) {
                    try {
                        String javaCmd = statementVal.substring(0, statementVal.length() - 2);
                        String methodName = StringUtils.split(javaCmd, " ")[1];
                        ReflectionUtils.invokeStaticMethod(DbUpgradeHelper.class, methodName, null, null);
                    } catch (Exception e) {
                    }
                } else {
                    executeSQLStatement(db, statementVal);
                }
                statement = new StringBuilder();
            }
        }
    }

    private static void executeSQLStatement(Object db, String sql) {
        if (db instanceof SQLiteDatabase) {
            SQLiteDatabase sqLiteDatabase = (SQLiteDatabase) db;
            sqLiteDatabase.execSQL(sql);
        } else if (db instanceof net.sqlcipher.database.SQLiteDatabase) {
            net.sqlcipher.database.SQLiteDatabase sqlchipherDb = (net.sqlcipher.database.SQLiteDatabase) db;
            sqlchipherDb.execSQL(sql);
        }
    }

    public static void migrateAlbumFrom183() {
        /*Log.e("XXXXXXXXXXXX", "migrateAlbumFrom183");
        try {
            Cursor cursor = Requery.execQuery("OldAlbum");
            if(cursor == null){
                Timber.e("QUERY OLDALBUM FAILED");
                return;
            }

            long accountId = -1;
            long subAccountId = -1;

            while(cursor.moveToNext()){

                long videoId = cursor.getLong(cursor.getColumnIndex("videoId"));
                String imdbId = cursor.getString(cursor.getColumnIndex("imdbId"));
                String tmdbId = cursor.getString(cursor.getColumnIndex("tmdbId"));
                String metaId = cursor.getString(cursor.getColumnIndex("metaId"));
                long currentPlaySeason = cursor.getLong(cursor.getColumnIndex("currentPlaySeason"));
                long currentPlayEpisode = cursor.getLong(cursor.getColumnIndex("currentPlayEpisode"));
                long currentPlaySeasonId = cursor.getLong(cursor.getColumnIndex("currentPlaySeasonId"));
                long currentPlayEpisodeId = cursor.getLong(cursor.getColumnIndex("currentPlayEpisodeId"));
                String currentPlayEpisodeTitle = cursor.getString(cursor.getColumnIndex("currentPlayEpisodeTitle"));
                String currentPlayId = cursor.getString(cursor.getColumnIndex("currentPlayId"));
                String currentPlayeSourceType = cursor.getString(cursor.getColumnIndex("currentPlaySourceType"));
                String currentPlaySourceId = cursor.getString(cursor.getColumnIndex("currentPlaySourceId"));
                int collectionTime = cursor.getInt(cursor.getColumnIndex("collectionTime"));
                int inFavorite = cursor.getInt(cursor.getColumnIndex("inFavorite"));
                int inWatchlis = cursor.getInt(cursor.getColumnIndex("inWatchlist"));
                int inCache = cursor.getInt(cursor.getColumnIndex("inCache"));
                int linked = cursor.getInt(cursor.getColumnIndex("linked"));
                int played = cursor.getInt(cursor.getColumnIndex("played"));
                String navType = cursor.getString(cursor.getColumnIndex("navType"));
                String videoType = cursor.getString(cursor.getColumnIndex("videoType"));
                String title = cursor.getString(cursor.getColumnIndex("title"));
                String pic = cursor.getString(cursor.getColumnIndex("pic"));
                String backDrop = cursor.getString(cursor.getColumnIndex("backDrop"));
                String cacheFilePath = cursor.getString(cursor.getColumnIndex("cacheFilePath"));
                long playedTime = cursor.getLong(cursor.getColumnIndex("playedTime"));
                long inCacheTime = cursor.getLong(cursor.getColumnIndex("inCacheTime"));
                long inWatchlistTime = cursor.getLong(cursor.getColumnIndex("inWatchlistTime"));
                long inFavoriteTime = cursor.getLong(cursor.getColumnIndex("inFavoriteTime"));
                int duration = cursor.getInt(cursor.getColumnIndex("duration"));

                Album album = new Album();

                album.setAccountId(accountId);
                album.setSubAccountId(subAccountId);
                album.setAccountType(UserManager.getInstance().getAccountType().ordinal());
                album.setMetaId(videoId);
                album.setMetaId2(metaId);
                album.setImdbId(imdbId);
                album.setTmdbId(tmdbId);
                album.setCurrentPlaySeason(currentPlaySeason);
                album.setCurrentPlaySeasonId(currentPlaySeasonId);
                album.setCurrentPlayEpisode(currentPlayEpisode);
                album.setCurrentPlayEpisodeId(currentPlayEpisodeId);
                album.setCurrentPlayEpisodeTitle(currentPlayEpisodeTitle);
                album.setCurrentPlayId(currentPlayId);
                album.setCurrentPlaySourceType(currentPlayeSourceType);
                album.setCurrentPlaySourceType(currentPlayeSourceType);
                album.setCurrentPlaySourceId(currentPlaySourceId);
                album.setCollectionTime(collectionTime);
                album.setInFavorite(inFavorite);
                album.setInFavoriteTime(inFavoriteTime);
                album.setInWatchlist(inWatchlis);
                album.setInWatchlistTime(inWatchlistTime);
                album.setInCache(inCache);
                album.setInCacheTime(inCacheTime);
                album.setCacheFilePath(cacheFilePath);
                album.setLinked(linked);
                album.setPlayed(played);
                album.setPlayedTime(playedTime);
                album.setNavType(navType);
                album.setVideoType(videoType);
                album.setTitle(title);
                album.setPic(pic);
                album.setBackDrop(backDrop);
                album.setDuration(duration);
                album.setFavoriteSync(0);
                album.setWatchlistSync(0);
                album.setHistorySync(0);
                album.setSubAccountId(-1);
                album.setAccountId(-1);
                if(album.getInFavorite() == 1 && album.getInFavoriteTime() == 0){
                    album.setInFavoriteTime(System.currentTimeMillis());
                }
                if(album.getInWatchlist() == 1 && album.getInWatchlistTime() == 0){
                    album.setInWatchlistTime(System.currentTimeMillis());
                }
                if(album.getPlayed() == 1 && album.getPlayedTime() == 0){
                    album.setPlayedTime(System.currentTimeMillis());
                }

                Requery.store().insert(album);
                //VodDao.getInstance().addAlbums(album);
                LogUtils.printfAlbumInfo(album, "MIGRATION ALBUM");
            }

            cursor.close();

            //数据迁移完毕，删除旧表
            Requery.execSQL("drop table OldAlbum");
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
        }*/
    }
}
