//package com.mm.c.cloud.lib.dao;
//
//import android.content.Context;
//import android.content.pm.PackageInfo;
//import android.database.sqlite.SQLiteDatabase;
//
//import com.mm.c.Models;
//import com.mm.c.cloud.BuildConfig;
//
//import io.requery.Persistable;
//import io.requery.android.sqlcipher.SqlCipherDatabaseSource;
//import io.requery.android.sqlite.DatabaseSource;
//import io.requery.meta.Attribute;
//import io.requery.meta.EntityModel;
//import io.requery.reactivex.ReactiveEntityStore;
//import io.requery.reactivex.ReactiveSupport;
//import io.requery.sql.Configuration;
//import io.requery.sql.EntityDataStore;
//import io.requery.sql.SchemaModifier;
//import io.requery.sql.TableCreationMode;
//import io.requery.sql.platform.SQLite;
//
///**
// * Requery ORM controller
// */
//public class Requery {
//
//    private static final String TAG = Requery.class.getSimpleName();
//    private static final String DB_FILE_PATH = "mfc_store_dev.db";
//    private static final String DB_FILE_PATH_CIPHER = "mfc_store_rel.db";
//    private static EntityDataStore<Persistable> dataStore;
//    private static ReactiveEntityStore<Persistable> rxDataStore;
//    private static SchemaModifier schemaModifier;
//    private static Object databaseSource;
//
////    public static void tear() {
////    }
//
//    public static void init(Context context, String password) {
//        if (dataStore == null) {
//            try {
//                PackageInfo pinfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
//                int versionNumber = pinfo.versionCode;
//                String versionName = pinfo.versionName;
//                // override onUpgrade to handle migrating to a new version
//
//                Configuration configuration = null;
//                //todo 暂时不启用加密数据库功能
//                if (BuildConfig.DEBUG) {
//                    //调试模式不加密
//                    DatabaseSource source = new ExDatabaseSource(context, Models.DEFAULT, DB_FILE_PATH, versionNumber);
//                    databaseSource = source;
//                    source.setLoggingEnabled(true);
//                    //todo 开发阶段，每次升级都删除旧表
//                    //source.setTableCreationMode(TableCreationMode.DROP_CREATE);
//                    source.setTableCreationMode(TableCreationMode.CREATE_NOT_EXISTS);
//                    configuration = source.getConfiguration();
//                } else {
//                    //生产模式需要加密
//                    //todo 尚未正确加密设置 SQLCipher和密码
//                    SqlCipherDatabaseSource source = new ExSqlCipherDatabaseSource(context, Models.DEFAULT, DB_FILE_PATH_CIPHER, password, versionNumber);
//                    databaseSource = source;
//                    source.setLoggingEnabled(false);
//                    //todo 开发阶段，每次升级都删除旧表
//                    //source.setTableCreationMode(TableCreationMode.DROP_CREATE);
//                    source.setTableCreationMode(TableCreationMode.CREATE_NOT_EXISTS);
//                    configuration = source.getConfiguration();
//                }
//                dataStore = new EntityDataStore<>(configuration);
//                schemaModifier = new SchemaModifier(configuration);
//                rxDataStore = ReactiveSupport.toReactiveStore(dataStore);
//
//                //DBHelper.getInstance(databaseSource).dropAllTables();/////test
//            } catch (Exception e) {
//                throw new RuntimeException("Init ORM error", e);
//            }
//        }
//    }
//
//    public static <T> void addColumn(Attribute<T, ?> attribute) {
//        schemaModifier.addColumn(attribute);
//    }
//
//    public static EntityDataStore<Persistable> store() {
//        if (dataStore == null) {
//            throw new RuntimeException("Requery data store should be initialized in application");
//        }
//        return dataStore;
//    }
//
//    public static ReactiveEntityStore<Persistable> rxStore() {
//        if (rxDataStore == null) {
//            throw new RuntimeException("Requery data rx store should be initialized in application");
//        }
//        return rxDataStore;
//    }
//
//    public static Object getDatabaseSource() {
//        return databaseSource;
//    }
//
//    public static void execSQL(String sql) {
//        if (databaseSource == null) {
//            throw new RuntimeException("Requery database source should be initialized in application");
//        }
//        if (databaseSource instanceof DatabaseSource) {
//            ((DatabaseSource) databaseSource).getWritableDatabase().execSQL(sql);
//        } else if (databaseSource instanceof SqlCipherDatabaseSource) {
//            ((SqlCipherDatabaseSource) databaseSource).getWritableDatabase().execSQL(sql);
//        }
//    }
//
//    private static class ExDatabaseSource extends DatabaseSource {
//        private Context context;
//
//        public ExDatabaseSource(Context context, EntityModel model, int version) {
//            super(context, model, version);
//            this.context = context;
//        }
//
//        public ExDatabaseSource(Context context, EntityModel model, String name, int version) {
//            super(context, model, name, version);
//            this.context = context;
//        }
//
//        public ExDatabaseSource(Context context, EntityModel model, String name, SQLiteDatabase.CursorFactory factory, int version) {
//            super(context, model, name, factory, version);
//            this.context = context;
//        }
//
//        public ExDatabaseSource(Context context, EntityModel model, String name, SQLiteDatabase.CursorFactory factory, int version, SQLite platform) {
//            super(context, model, name, factory, version, platform);
//            this.context = context;
//        }
//
//        @Override
//        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
//            DbUpgradeHelper.executeManualUpgrade(db, context, oldVersion, newVersion);
//            DBHelper.getInstance(db).upgradeDatabase(context, oldVersion, newVersion);
//            super.onUpgrade(db, oldVersion, newVersion);
//        }
//    }
//
//    private static class ExSqlCipherDatabaseSource extends SqlCipherDatabaseSource {
//        private Context context;
//
//        public ExSqlCipherDatabaseSource(Context context, EntityModel model, String name, String password, int version) {
//            super(context, model, name, password, version);
//            this.context = context;
//        }
//
//        @Override
//        public void onUpgrade(net.sqlcipher.database.SQLiteDatabase db, int oldVersion, int newVersion) {
//            DbUpgradeHelper.executeManualUpgrade(db, context, oldVersion, newVersion);
//            DBHelper.getInstance(db).upgradeDatabase(context, oldVersion, newVersion);
//            super.onUpgrade(db, oldVersion, newVersion);
//        }
//    }
//}
