package com.mm.c.cloud.lib.dao.model;

import java.util.Date;

import io.requery.Column;
import io.requery.Entity;
import io.requery.Index;
import io.requery.Key;

/**
 * Created by Larry on 2016/5/13.
 */
@Entity(cacheable = false,stateless = true)
public class BaseCloudFolder {
    @Key
    // 数据库逻辑主键 account id + folder path
    protected String id;
    //对应CloudAccount的PK id
    @Column(index = true)
    @Index("idx_acct")
    protected String acctId;
    //可访问的路径。例如 "xxx@outlook.com:myfolder"
    protected String path;
    //网盘文件夹的checksum，用于识别网盘的文件变化标识,比如:文件夹的大小，或者指定文件的时间戳
    protected String changeChecksum;
    //网盘中扫描获得的视频个数. 这里是视频文件的数量，比如电视剧的一集算一个
    protected int fileCount;
    //创建日期
    protected Date createDate;
    //最后更新日期
    protected Date updateDate;
}
