package com.mm.c.cloud.lib.device;

import android.os.Build;

import com.mm.c.cloud.lib.misc.AppContextUtils;
import com.mm.c.cloud.lib.misc.utils.SystemPropertiesProxy;

import de.greenrobot.common.StringUtils;

/**
 * Created by elegant.wang on 2017/12/8.
 */

public class BuildInfo {
    private String androidVersion;
    private int sdk;
    private String productBrand;
    private String productModel;
    private String productBoard;
    private String productDevice;
    private String productManufacturer;

    private String buildFingerprint;
    private String buildDisplay;
    private String buildType;
    private String buildUser;
    private String buildHost;
    private long buildDateUtc;
    private String buildTags;
    private String buildId;

    private String hardware; //ro.hardware
    private String bootloader;

    private String firmware;

    private BuildInfo() {
        androidVersion = Build.VERSION.RELEASE;
        sdk = Build.VERSION.SDK_INT;
        productBrand = Build.BRAND;
        productModel = Build.MODEL;
        productBoard = Build.BOARD;
        productDevice = Build.DEVICE;
        productManufacturer = Build.MANUFACTURER;
        bootloader = Build.BOOTLOADER;

        buildFingerprint = Build.FINGERPRINT;
        buildDisplay = Build.DISPLAY;
        buildType = Build.TYPE;
        buildUser = Build.USER;
        buildHost = Build.HOST;
        buildDateUtc = Build.TIME;
        buildTags = Build.TAGS;
        buildId = Build.ID;

        hardware = Build.HARDWARE;
        bootloader = Build.BOOTLOADER;
        firmware = SystemPropertiesProxy.get(AppContextUtils.getContext(), "ro.product.firmware");
    }

    private static class Holder {
        private static final BuildInfo INSTANCE = new BuildInfo();
    }

    public static final BuildInfo getInstance() {
        return Holder.INSTANCE;
    }

    public String getAndroidVersion() {
        return androidVersion;
    }

    public int getSdk() {
        return sdk;
    }

    public void setSdk(int sdk) {
        this.sdk = sdk;
    }

    public String getProductBrand() {
        return productBrand;
    }

    public String getProductModel() {
        return productModel;
    }

    public String getProductBoard() {
        return productBoard;
    }

    public String getProductDevice() {
        return productDevice;
    }

    public String getProductManufacturer() {
        return productManufacturer;
    }

    public String getBuildFingerprint() {
        return buildFingerprint;
    }

    public String getBuildDisplay() {
        return buildDisplay;
    }

    public String getBuildType() {
        return buildType;
    }

    public String getBuildUser() {
        return buildUser;
    }

    public String getBuildHost() {
        return buildHost;
    }

    public long getBuildDateUtc() {
        return buildDateUtc;
    }

    public String getBuildTags() {
        return buildTags;
    }

    public String getBuildId() {
        return buildId;
    }

    public String getHardware() {
        return hardware;
    }

    public String getBootloader() {
        return bootloader;
    }

    public String getFirmware() {
        return firmware;
    }

    @Override
    public String toString() {
        return "BuildInfo{" +
                "androidVersion='" + androidVersion + '\'' +
                ", sdk=" + sdk +
                ", productBrand='" + productBrand + '\'' +
                ", productModel='" + productModel + '\'' +
                ", productBoard='" + productBoard + '\'' +
                ", productDevice='" + productDevice + '\'' +
                ", productManufacturer='" + productManufacturer + '\'' +
                ", buildFingerprint='" + buildFingerprint + '\'' +
                ", buildDisplay='" + buildDisplay + '\'' +
                ", buildType='" + buildType + '\'' +
                ", buildUser='" + buildUser + '\'' +
                ", buildHost='" + buildHost + '\'' +
                ", buildDateUtc=" + buildDateUtc +
                ", buildTags='" + buildTags + '\'' +
                ", buildId='" + buildId + '\'' +
                ", hardware='" + hardware + '\'' +
                ", bootloader='" + bootloader + '\'' +
                '}';
    }

    public String checksum() {
        return StringUtils.generateMD5String(toString());
    }
}
