package com.mm.c.cloud.lib.device;

import com.google.gson.annotations.Expose;

/**
 * Created by elegant.wang on 2018/3/2.
 */

public class DeviceInfo {
    private String androidVersion;
    private int sdk;
    private String productBrand;
    private String productModel;
    private String productBoard;
    private String productDevice;
    private String productManufacturer;

    private String buildFingerprint;
    private String buildDisplay;
    private String buildType;
    private String buildUser;
    private String buildHost;
    private long buildDateUtc;
    private String buildTags;
    private String buildId;

    private String hardware; //ro.hardware
    private String bootloader;

    private String ethernetMac;
    private String wifiMac;
    private String bluetoothMac;
    private String cpuHardware;
    private String cpuSerial;
    private long ramSize;
    private long romSize;
    @Expose
    private String cpuinfo;

    private String imei;
    private String androidId;

    public DeviceInfo(BuildInfo buildInfo, HardwareInfo hardwareInfo) {
        androidVersion = buildInfo.getAndroidVersion();
        sdk = buildInfo.getSdk();
        productBrand = buildInfo.getProductBrand();
        productModel = buildInfo.getProductModel();
        productBoard = buildInfo.getProductBoard();
        productDevice = buildInfo.getProductDevice();
        productManufacturer = buildInfo.getProductManufacturer();
        buildFingerprint = buildInfo.getBuildFingerprint();
        buildDisplay = buildInfo.getBuildDisplay();
        buildType = buildInfo.getBuildType();
        buildUser = buildInfo.getBuildUser();
        buildHost = buildInfo.getBuildHost();
        buildDateUtc = buildInfo.getBuildDateUtc();
        buildTags = buildInfo.getBuildTags();
        buildId = buildInfo.getBuildId();
        hardware = buildInfo.getHardware();
        bootloader = buildInfo.getBootloader();

        ethernetMac = hardwareInfo.getEthernetMac();
        wifiMac = hardwareInfo.getWifiMac();
        bluetoothMac = hardwareInfo.getBluetoothMac();
        cpuHardware = hardwareInfo.getCpuHardware();
        cpuSerial = hardwareInfo.getCpuSerial();
        ramSize = hardwareInfo.getRamSize();
        romSize = hardwareInfo.getRomSize();
        cpuinfo = hardwareInfo.getCpuinfo();
        imei = hardwareInfo.getImei();
        androidId = hardwareInfo.getAndroidId();
    }

    public String getAndroidVersion() {
        return androidVersion;
    }

    public void setAndroidVersion(String androidVersion) {
        this.androidVersion = androidVersion;
    }

    public int getSdk() {
        return sdk;
    }

    public void setSdk(int sdk) {
        this.sdk = sdk;
    }

    public String getProductBrand() {
        return productBrand;
    }

    public void setProductBrand(String productBrand) {
        this.productBrand = productBrand;
    }

    public String getProductModel() {
        return productModel;
    }

    public void setProductModel(String productModel) {
        this.productModel = productModel;
    }

    public String getProductBoard() {
        return productBoard;
    }

    public void setProductBoard(String productBoard) {
        this.productBoard = productBoard;
    }

    public String getProductDevice() {
        return productDevice;
    }

    public void setProductDevice(String productDevice) {
        this.productDevice = productDevice;
    }

    public String getProductManufacturer() {
        return productManufacturer;
    }

    public void setProductManufacturer(String productManufacturer) {
        this.productManufacturer = productManufacturer;
    }

    public String getBuildFingerprint() {
        return buildFingerprint;
    }

    public void setBuildFingerprint(String buildFingerprint) {
        this.buildFingerprint = buildFingerprint;
    }

    public String getBuildDisplay() {
        return buildDisplay;
    }

    public void setBuildDisplay(String buildDisplay) {
        this.buildDisplay = buildDisplay;
    }

    public String getBuildType() {
        return buildType;
    }

    public void setBuildType(String buildType) {
        this.buildType = buildType;
    }

    public String getBuildUser() {
        return buildUser;
    }

    public void setBuildUser(String buildUser) {
        this.buildUser = buildUser;
    }

    public String getBuildHost() {
        return buildHost;
    }

    public void setBuildHost(String buildHost) {
        this.buildHost = buildHost;
    }

    public long getBuildDateUtc() {
        return buildDateUtc;
    }

    public void setBuildDateUtc(long buildDateUtc) {
        this.buildDateUtc = buildDateUtc;
    }

    public String getBuildTags() {
        return buildTags;
    }

    public void setBuildTags(String buildTags) {
        this.buildTags = buildTags;
    }

    public String getBuildId() {
        return buildId;
    }

    public void setBuildId(String buildId) {
        this.buildId = buildId;
    }

    public String getHardware() {
        return hardware;
    }

    public void setHardware(String hardware) {
        this.hardware = hardware;
    }

    public String getBootloader() {
        return bootloader;
    }

    public void setBootloader(String bootloader) {
        this.bootloader = bootloader;
    }

    public String getEthernetMac() {
        return ethernetMac;
    }

    public void setEthernetMac(String ethernetMac) {
        this.ethernetMac = ethernetMac;
    }

    public String getWifiMac() {
        return wifiMac;
    }

    public void setWifiMac(String wifiMac) {
        this.wifiMac = wifiMac;
    }

    public String getBluetoothMac() {
        return bluetoothMac;
    }

    public void setBluetoothMac(String bluetoothMac) {
        this.bluetoothMac = bluetoothMac;
    }

    public String getCpuHardware() {
        return cpuHardware;
    }

    public void setCpuHardware(String cpuHardware) {
        this.cpuHardware = cpuHardware;
    }

    public String getCpuSerial() {
        return cpuSerial;
    }

    public void setCpuSerial(String cpuSerial) {
        this.cpuSerial = cpuSerial;
    }

    public long getRamSize() {
        return ramSize;
    }

    public void setRamSize(long ramSize) {
        this.ramSize = ramSize;
    }

    public long getRomSize() {
        return romSize;
    }

    public void setRomSize(long romSize) {
        this.romSize = romSize;
    }

    public String getCpuinfo() {
        return cpuinfo;
    }

    public void setCpuinfo(String cpuinfo) {
        this.cpuinfo = cpuinfo;
    }

    public String getImei() {
        return imei;
    }

    public void setImei(String imei) {
        this.imei = imei;
    }

    public String getAndroidId() {
        return androidId;
    }

    public void setAndroidId(String androidId) {
        this.androidId = androidId;
    }
}
