package com.mm.c.cloud.lib.eventbus;

import android.content.Context;

import com.mm.c.cloud.lib.logger.LogUtils;
import com.mm.c.cloud.lib.logger.TimberUtils;
import com.mm.c.cloud.manager.GlobalCloudManager;

import org.greenrobot.eventbus.EventBus;

/**
 * Event bus provider
 */
public class BusProvider {
    private final static String TAG = BusProvider.class.getSimpleName();
    private static BusProvider instance;

    public static BusProvider getInstance() {
        if(instance == null){
            instance = new BusProvider(GlobalCloudManager.getInstance().getCallback().getApplication());
        }
        return instance;
    }

//    public static void init(Context context) {
//        LogUtils.printfThreadInfo(TAG, "BusProviderInit");
//        if (instance == null) {
//            instance = new BusProvider(context);
//        }
//    }

    private BusProvider(Context context) {
        MyHermesEventBus.getDefault().init(context);
    }

    public void post(final Object event) {
        EventBus.getDefault().post(event);
    }

    public void postSticky(final Object event) {
        EventBus.getDefault().postSticky(event);
    }

    public <T> T getStickyEvent(final Class<T> eventType) {
        return EventBus.getDefault().getStickyEvent(eventType);
    }

    public <T> T removeStickyEvent(final Class<T> eventType) {
        return EventBus.getDefault().removeStickyEvent(eventType);
    }

    public boolean removeStickyEvent(final Object event) {
        return EventBus.getDefault().removeStickyEvent(event);
    }


    public void register(final Object subscriber) {
        try {
            if (!MyHermesEventBus.getDefault().isRegistered(subscriber)) {
                EventBus.getDefault().register(subscriber);
            }
        } catch (Exception e) {
            TimberUtils.e(e, "BusProvider register error!");
        }
        LogUtils.i(TAG, "BusProvider register, init total time : " + "ms");
    }

    public void unregister(final Object subscriber) {
        try {
            if (MyHermesEventBus.getDefault().isRegistered(subscriber)) {
                EventBus.getDefault().unregister(subscriber);
            }
        } catch (Throwable e) {
            TimberUtils.e(e, "BusProvider unregister error!");
        }
    }

    public boolean isRegistered(final Object subscriber) {
        return EventBus.getDefault().isRegistered(subscriber);
    }

    public void postCross(final Object event) {
        MyHermesEventBus.getDefault().post(event);
    }
}


