package com.mm.c.cloud.lib.logger;

import android.util.Log;

import com.mm.c.cloud.BuildConfig;

public class LogUtils {
    private static boolean DEBUG_ON = BuildConfig.DEBUG;

    public static void i(String tag, String msg) {
        if (DEBUG_ON) Log.i(tag, msg);
    }

    public static void i(String tag, String msg, Throwable throwable) {
        if (DEBUG_ON) Log.i(tag, msg, throwable);
    }

    public static void e(String tag, String msg) {
        if (DEBUG_ON) Log.e(tag, msg);
    }

    public static void e(String tag, String msg, Throwable throwable) {
        if (DEBUG_ON) Log.e(tag, msg, throwable);
    }

    public static void printfThreadInfo(String TAG, String methodName) {
        if (DEBUG_ON)
            Log.i(TAG, methodName + ",current threadName : " + Thread.currentThread().getName() +
                    ", current threadId : " + Thread.currentThread().getId());
    }

    public static void printfTag(String TAG1, String TAG2) {
        if (!DEBUG_ON) return;
        Log.i(TAG1, "==========================================================================");
        Log.i(TAG1, "|                                                                        |");
        Log.i(TAG1, "|                              " + TAG2 + "                                 |");
        Log.i(TAG1, "|                                                                        |");
        Log.i(TAG1, "==========================================================================");
    }
}
