package com.mm.c.cloud.lib.logger;

import android.util.Log;

import org.apache.commons.lang3.StringUtils;

public class Logger {

    public static int LOG_LEVEL  = 2;
    public static int VERBOSE  = 5;
    public static int DEBUG  = 4;
    public static int INFO  = 3;
    public static int WARN  = 2;
    public static int ERROR  = 1;

    public static void v(String tag,String msg){
        if(LOG_LEVEL>VERBOSE){
            Log.v(tag, StringUtils.trimToEmpty(msg));
        }
    }

    public static void i(String tag,String msg){
        if(LOG_LEVEL>INFO){
            Log.i(tag, StringUtils.trimToEmpty(msg));
        }
    }
    public static void w(String tag,String msg){
        if(LOG_LEVEL>WARN){
            Log.w(tag, StringUtils.trimToEmpty(msg));
        }
    }
    public static void e(String tag,String msg){
        if(LOG_LEVEL>ERROR){
            Log.e(tag, StringUtils.trimToEmpty(msg));
        }
    }

    public static void d(String tag, String format, Object... args) {
        String msg = String.format(format, args);
        Log.d(tag, msg);
    }
}
