package com.mm.c.cloud.lib.logger;

import timber.log.Timber;

public class TimberUtils {
    private static final TimberUtils ourInstance = new TimberUtils();

    public static TimberUtils getInstance() {
        return ourInstance;
    }

    private TimberUtils() {
    }

    //通过Timber工具上报异常，必须要在非UI线程，否则会引起ANR
    public static void e(final String message, final Object... args) {
        Timber.e(message, args);
    }

    public static void e(final Throwable t, final String message, final Object... args) {
        Timber.e(t, message, args);
    }
}
