package com.mm.c.cloud.lib.metric;

import android.content.Context;
import android.text.TextUtils;

import com.mm.c.cloud.BuildConfig;
import com.vms.metric.sender.service.MetricSender;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetricManager {
    private static MetricManager ourInstance = null;
    private Context mContext;
    private Object lock = new Object();

    private List<MetricProcessChain> chains = new ArrayList<>();

    public enum  MetricKey {
        APP,
        PM;
    }

    public static MetricManager getInstance() {
        if(null == ourInstance) {
            throw new RuntimeException(MetricManager.class.getSimpleName() + " not instantiated");
        }
        return ourInstance;
    }

    public static void init(Context context, String appId, String appKey, String urls) {
        if(null == ourInstance) {
            ourInstance = new MetricManager(context, appId, appKey, urls);
        }
    }

    private MetricManager(Context context, String appId, String appKey, String urls) {
        this.mContext = context;
        if(null != urls && TextUtils.isEmpty(urls.replace(" ", ""))) {
            return;
        }
        String[] urlsGroups = urls.split("#");
        Map<String, String[]> urlMap = new HashMap<>();
        for(int i = 0; i < urlsGroups.length; i++) {
            String[] urlArray = null;
            if(!TextUtils.isEmpty(urlsGroups[i])) {
                urlArray = urlsGroups[i].split(",");
            }
            if(i < MetricKey.values().length) {
                urlMap.put(MetricKey.values()[i].name(), urlArray);
            }
        }

        if(BuildConfig.DEBUG) {
            MetricSender.init(appId, appKey, urlMap, 100, 60000, true);
        } else {
            MetricSender.init(appId, appKey, urlMap);
        }
    }

    public void addMetricChain(MetricProcessChain chain) {
        synchronized (lock) {
            chains.clear();
            chains.add(chain);
        }
    }

    @Deprecated
    public void put(String action) {
        put(action, new MetricData.Builder().build());
    }

    @Deprecated
    public void put(String action, MetricData data) {
        synchronized (lock) {
            if (null != chains) {
                for (MetricProcessChain chain : chains) {
                    data = chain.process(data);
                }
            }
        }
        MetricSender.put(MetricKey.APP.name(), action, data.value());
    }

    public void put(MetricKey metricKey, String action) {
        put(metricKey, action, new MetricData.Builder().build());
    }

    public void put(MetricKey metricKey, String action, MetricData data) {
        if(MetricKey.APP.equals(metricKey)) {
            synchronized (lock) {
                if (null != chains) {
                    for (MetricProcessChain chain : chains) {
                        data = chain.process(data);
                    }
                }
            }
        }
        MetricSender.put(metricKey.name(), action, data.value());
    }
}
