package com.mm.c.cloud.lib.misc;

import android.os.Handler;
import android.os.HandlerThread;

public class TortoiseWork {
    private static final int TRACE_NUMBER = 1;
    private static TortoiseWork sInstance;
    private HandlerThread[] mWalkTraces;
    private Handler[] mTraceEntrances;

    public static TortoiseWork getInstance() {
        if (sInstance == null) {
            synchronized (TortoiseWork.class) {
                if (sInstance == null)
                    sInstance = new TortoiseWork();
            }
        }
        return sInstance;
    }

    private TortoiseWork() {
        mWalkTraces = new HandlerThread[TRACE_NUMBER];
        mTraceEntrances = new Handler[TRACE_NUMBER];
        for (int i = 0; i < TRACE_NUMBER; i++) {
            mWalkTraces[i] = new HandlerThread("tortoise work thread #" + i);
            mWalkTraces[i].start();
            mTraceEntrances[i] = new Handler(mWalkTraces[i].getLooper());
        }
    }

    public boolean post(Runnable action, int whichTrace) {
        if (whichTrace >= TRACE_NUMBER)
            throw new RuntimeException("trace not exists");
        return mTraceEntrances[whichTrace].post(action);
    }

    public boolean postDelayed(Runnable action, int whichTrace, long delayMillis) {
        if (whichTrace >= TRACE_NUMBER)
            throw new RuntimeException("trace not exists");
        return mTraceEntrances[whichTrace].postDelayed(action, delayMillis);
    }

    public void removeCallbacks(Runnable action, int whichTrace) {
        if (whichTrace >= TRACE_NUMBER)
            throw new RuntimeException("trace not exists");
        mTraceEntrances[whichTrace].removeCallbacks(action);
    }

    public boolean post(Runnable action) {
        return post(action, 0);
    }

    public boolean postDelayed(Runnable action, long delayMillis) {
        return postDelayed(action, 0, delayMillis);
    }

    public void removeCallbacks(Runnable action) {
        removeCallbacks(action, 0);
    }
}
