package com.mm.c.cloud.lib.misc.crypto;

import android.util.Base64;
import android.util.Log;

import java.security.Key;
import java.security.SecureRandom;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

/**
 * Created by elegant.wang on 2016/8/8.
 */
public class AESCodecAndroid {
    private static final String TAG = AESCodecAndroid.class.getCanonicalName();
    private static final String KEY_ALGORITHM = "AES";
    private static final int KEY_LNE = 128;

    public AESCodecAndroid() {
    }

    public static byte[] initkey(String keyString) throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance("AES");
        kg.init(128, new SecureRandom(keyString.getBytes()));
        SecretKey secretKey = kg.generateKey();
        return secretKey.getEncoded();
    }

    public static String generateKey(String keyString) {
        try {
            return Base64.encodeToString(initkey(keyString), Config.BASE64_FLAG);
        } catch (Exception var2) {
            Log.e(TAG, "generateKey failed." + var2);
            return "";
        }
    }

    public static byte[] decodeKey(String base64String) {
        return Base64.decode(base64String, Config.BASE64_FLAG);
    }

    public static Key codeToKey(String key) throws Exception {
        byte[] keyBytes = Base64.decode(key, Config.BASE64_FLAG);
        SecretKeySpec secretKey = new SecretKeySpec(keyBytes, "AES");
        return secretKey;
    }

    private static String decrypt(byte[] data, byte[] key) throws Exception {
        SecretKeySpec k = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(Cipher.DECRYPT_MODE, k);
        return new String(cipher.doFinal(data), "UTF-8");
    }

    private static byte[] decryptBytes(byte[] data, byte[] key) throws Exception {
        SecretKeySpec k = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(Cipher.DECRYPT_MODE, k);
        return cipher.doFinal(data);
    }

    public static String decrypt(String data, String key) throws Exception {
        return decrypt(Base64.decode(data, Config.BASE64_FLAG), Base64.decode(key, Config.BASE64_FLAG));
    }

    public static byte[] decryptBytes(String data, String key) throws Exception {
        return decryptBytes(Base64.decode(data, Config.BASE64_FLAG), Base64.decode(key, Config.BASE64_FLAG));
    }

    public static byte[] encrypt(byte[] data, byte[] key) throws Exception {
        SecretKeySpec k = new SecretKeySpec(key, "AES");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, k);
        return cipher.doFinal(data);
    }

    public static String encrypt(String data, String key) throws Exception {
        byte[] dataBytes = data.getBytes("UTF-8");
        byte[] keyBytes = Base64.decode(key, Config.BASE64_FLAG);
        return Base64.encodeToString(encrypt(dataBytes, keyBytes), Config.BASE64_FLAG);
    }
}
