package com.mm.c.cloud.lib.misc.lock;

import android.content.Context;
import android.os.PowerManager;

import com.mm.c.cloud.manager.GlobalCloudManager;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

import timber.log.Timber;

public class LockManager {
    public static final String PLAYER_WAKE_LOCK_KEY = "player_wake_lock_key";
    private static LockManager instance;
    private static final String TAG = "LockManager";

    //private Context mContext;
    private PowerManager mPowerManager;

    private ConcurrentHashMap<String, PowerManager.WakeLock> wakeLockMap;
    private ConcurrentHashMap<String, ReentrantLock> entrantLockMap;
    private ConcurrentHashMap<String, AtomicBoolean> stateLockMap;

    private LockManager(Context context) {
        //mContext = context;
        mPowerManager = (PowerManager) context.getSystemService(Context.POWER_SERVICE);
        wakeLockMap = new ConcurrentHashMap<>();
        entrantLockMap = new ConcurrentHashMap<>();
        stateLockMap = new ConcurrentHashMap<>();
    }

//    static {
//        IInitQuery.addItem(new IAction<Boolean>() {
//            @Override
//            public Boolean get() {
//                return instance != null;
//            }
//        });
//    }
//
//    public static void tear() {
//    }
//
//    public static void init(Context context) {
//        LogUtils.printfThreadInfo(TAG, "LockManagerInit");
//        if (instance == null) {
//            instance = new LockManager(context.getApplicationContext());
//        }
//        LogUtils.i(TAG, "LockManagerInit, init total time : ");
//    }

    public static LockManager getInstance(Context context) {
        if (instance == null) {
            synchronized (LockManager.class) {
                if (instance == null) {
                    instance = new LockManager(GlobalCloudManager.getInstance().getCallback().getApplication());
                }
            }
        }
        return instance;
    }

    private int acquireTime = 0;

    public boolean acquireWakeLock(String key) {
        PowerManager.WakeLock wakeLock = wakeLockMap.get(key);
        if (wakeLock != null) {
            if (wakeLock.isHeld()) return false;
            else {
                try {
                    wakeLock.acquire();
                } catch (Exception e) {
                    acquireTime++;
                    Timber.i("acquire wakelock exception");
                    if (acquireTime > 5) {
                        acquireTime = 0;
                        return false;
                    } else {
                        return acquireWakeLock(key);
                    }
                }
                acquireTime = 0;
                return true;
            }
        } else {
            // PowerManager.SCREEN_BRIGHT_WAKE_LOCK
            // PowerManager.SCREEN_DIM_WAKE_LOCK |
            //PowerManager.ACQUIRE_CAUSES_WAKEUP |
            wakeLock = mPowerManager.newWakeLock(PowerManager.SCREEN_BRIGHT_WAKE_LOCK | PowerManager.ON_AFTER_RELEASE, key);
            wakeLockMap.put(key, wakeLock);
            wakeLock.acquire();
            acquireTime = 0;
            return true;
        }
    }

    public boolean releaseWakeLock(String key) {
        if (wakeLockMap.containsKey(key) && wakeLockMap.get(key).isHeld()) {
            wakeLockMap.get(key).release();
            return true;
        } else {
            return false;
        }
    }

    public boolean isWakeLockHeld(String key) {
        if (wakeLockMap.containsKey(key) && wakeLockMap.get(key).isHeld()) return true;
        else return false;
    }

    public boolean acquireEntrantLock(String key) {
        if (entrantLockMap.containsKey(key)) {
            return entrantLockMap.get(key).tryLock();
        } else {
            ReentrantLock lock = new ReentrantLock();
            entrantLockMap.put(key, lock);
            return lock.tryLock();
        }
    }

    public boolean releaseEntrantLock(String key) {
        if (entrantLockMap.containsKey(key)) {
            entrantLockMap.get(key).unlock();
            return true;
        } else {
            return false;
        }
    }

    public synchronized boolean acquireStateLock(String key) {
        if (stateLockMap.containsKey(key)) {
            AtomicBoolean lock = stateLockMap.get(key);
            return lock.compareAndSet(false, true);
        } else {
            AtomicBoolean lock = new AtomicBoolean(true);
            stateLockMap.put(key, lock);
            return true;
        }
    }

    public synchronized boolean releaseStateLock(String key) {
        if (stateLockMap.containsKey(key)) {
            AtomicBoolean lock = stateLockMap.get(key);
            lock.set(false);
            return true;
        } else return false;
    }

    public boolean isStateLockHeld(String key) {
        AtomicBoolean lock = stateLockMap.get(key);
        return lock != null && lock.get();
    }

    public ConcurrentHashMap<String, PowerManager.WakeLock> getWakeLockMap() {
        return wakeLockMap;
    }
}
