package com.mm.c.cloud.lib.misc.ntp;

import java.util.Date;
import java.util.concurrent.TimeUnit;

public class SystemTimeProvider implements TimeProvider {
    public final static long DEFAULT_ERROR_LIMIT = TimeUnit.MINUTES.toMillis(5);// 默认允许误差时间
    private boolean initialized;

    @Override
    public Date now() {
        return new Date();
    }

    @Override
    public long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public boolean wasInitialized() {
        return initialized;
    }

    public void setSystemTime(long timestamp) {
        if (initialized) return;
        if (Math.abs(timestamp - System.currentTimeMillis()) <= DEFAULT_ERROR_LIMIT) {
            initialized = true;
            return;
        }
    }
}
