package com.mm.c.cloud.lib.misc.ntp;

import com.mm.c.cloud.lib.logger.LogUtils;
import com.mm.c.cloud.lib.misc.TortoiseWork;

import java.util.Date;
import java.util.concurrent.TimeUnit;

public class TrueTime {
    private static final String TAG = TrueTime.class.getSimpleName();
    private static TrueTime INSTANCE = new TrueTime();

//    static {
//        IInitQuery.addItem(new IAction<Boolean>() {
//            @Override
//            public Boolean get() {
//                return INSTANCE != null;
//            }
//        });
//    }
//    public static void tear(){}
    public static void init() {
        INSTANCE.sync();
    }

    public static TrueTime getInstance() {
        return INSTANCE;
    }

    private SystemTimeProvider mSystem;
    private ServerTimeProvider mServer;
    private SntpTimeProvider mSntp;
    private WebTimeProvider mWeb;


    private TrueTime() {
        mSystem = new SystemTimeProvider();
        mServer = new ServerTimeProvider();
        mSntp = new SntpTimeProvider();
        mWeb = new WebTimeProvider();
    }

    public Date now() {
        return new Date(currentTimeMillis());
    }

    public long currentTimeMillis() {
        if (mServer.wasInitialized()) return mServer.currentTimeMillis();
        if (mSystem.wasInitialized()) return mSystem.currentTimeMillis();
        if (mSntp.wasInitialized()) return mSntp.currentTimeMillis();
        if (mWeb.wasInitialized()) return mWeb.currentTimeMillis();
        return mSystem.currentTimeMillis();
    }

    public long trueTimeOrZero() {
        if (mSystem.wasInitialized()) return mSystem.currentTimeMillis();
        if (mSntp.wasInitialized()) return mSntp.currentTimeMillis();
        if (mServer.wasInitialized()) return mServer.currentTimeMillis();
        if (mWeb.wasInitialized()) return mWeb.currentTimeMillis();
        return 0;
    }

    public void sync() {
        TortoiseWork.getInstance().post(new Runnable() {
            @Override
            public void run() {
                ntpSync();
                webSync();
            }
        });
    }

    public void ntpSync() {
        LogUtils.printfThreadInfo(TAG, "TrueTimeInit_ntpSync");
        if (mSntp.requestNtpTime()) {
            mSystem.setSystemTime(mSntp.currentTimeMillis());
        } else {
            TortoiseWork.getInstance().postDelayed(new Runnable() {
                @Override
                public void run() {
                    ntpSync();
                }
            }, TimeUnit.MINUTES.toMillis(5));
        }
    }

    public void webSync() {
        LogUtils.printfThreadInfo(TAG, "TrueTimeInit_webSync");
        if (mWeb.requestWebTime()) {
            // mSystem.setSystemTime(mWeb.currentTimeMillis());
        } else {
            TortoiseWork.getInstance().postDelayed(new Runnable() {
                @Override
                public void run() {
                    webSync();
                }
            }, TimeUnit.MINUTES.toMillis(5));
        }
    }


    public void updateServerTime(long serverTime) {
        mServer.setServerTime(serverTime);
        mSystem.setSystemTime(serverTime);
    }
}
