package com.mm.c.cloud.lib.misc.ntp;

import android.os.SystemClock;

import com.mm.c.cloud.lib.logger.TimberUtils;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class WebTimeProvider implements TimeProvider {
    private final static List<String> webServers = new ArrayList<>();

    static {
        webServers.add("http://www.google.com");
        webServers.add("http://www.baidu.com");
    }

    private boolean initialized;
    private long webTime;
    private long lastUpdateTicks;

    @Override
    public Date now() {
        return new Date(currentTimeMillis());
    }

    @Override
    public long currentTimeMillis() {
        return webTime + SystemClock.elapsedRealtime() - lastUpdateTicks;
    }

    @Override
    public boolean wasInitialized() {
        return initialized;
    }

    public boolean requestWebTime() {
        if (!cacheExpired()) return true;
        for (String server : webServers) {
            try {
                URL url = new URL(server);
                HttpURLConnection httpURLConnection = (HttpURLConnection) url.openConnection();
                httpURLConnection.setConnectTimeout(15000);
                httpURLConnection.setConnectTimeout(15000);
                long date = httpURLConnection.getDate();
                httpURLConnection.disconnect();
                if (date > 0) {
                    webTime = date;
                    lastUpdateTicks = SystemClock.elapsedRealtime();
                    initialized = true;
                    TimberUtils.e("web time is %s", "" + date);
                    return true;
                } else {
                    continue;
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean cacheExpired() {
        return !wasInitialized() || (wasInitialized() && SystemClock.elapsedRealtime() - lastUpdateTicks >= TimeUnit.MINUTES.toMillis(60));
    }
}
