package com.mm.c.cloud.lib.misc.rx;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import rx.Subscriber;
import rx.exceptions.CompositeException;
import rx.exceptions.OnErrorFailedException;
import timber.log.Timber;

/**
 * 安全Subscriber, 为了Catch住 预料不到的Exception, 通过某种方式打印日志
 *
 * @param <T>
 */
public class SafeSubscriberEx<T> extends Subscriber<T> {
    static Handler mHandler;
    static final int MSG_ERROR = 0xAF;

    static {
        HandlerThread thread = new HandlerThread("SafeSubscriberEx");
        thread.start();
        mHandler = new Handler(thread.getLooper(), new Handler.Callback() {
            @Override
            public boolean handleMessage(Message msg) {
                if (msg.what == MSG_ERROR) {
                    try {
                        List<Throwable> throwables = (List<Throwable>) msg.obj;
                        String str = "SafeSubscriberEx: Exceptions receive size: " + throwables.size();
                        for (int i = 0; i < throwables.size(); i++) {
                            Throwable throwable = throwables.get(i);
                            str = str + "\n Exception " + i + " : \n";
                            str += getStackTraceString(throwable);
                        }
                        Timber.w(str);
                    } catch (Exception ignore) {
                    }
                }
                return true;
            }
        });
    }

    Subscriber<T> subscriber;

    public SafeSubscriberEx(Subscriber<T> subscriber) {
        this.subscriber = subscriber;
    }

    @Override
    public void onCompleted() {
        try {
            subscriber.onCompleted();
        } catch (Throwable throwable) {
            onError(throwable);
        }
    }

    @Override
    public void onError(Throwable e) {
        try {
            if (subscriber == null) return;
            subscriber.onError(e);
        } catch (Throwable throwable) {
            try {
                ArrayList<Throwable> tmpArr = new ArrayList<>();
                if (throwable instanceof OnErrorFailedException && throwable.getCause() instanceof CompositeException) {
                    List<Throwable> exs = ((CompositeException) throwable.getCause()).getExceptions();
                    if (exs != null && !exs.isEmpty()) {
                        tmpArr.addAll(exs);
                    }
                } else {
                    tmpArr.add(e);
                }
                mHandler.obtainMessage(MSG_ERROR, tmpArr).sendToTarget();
            } catch (Exception ignore) {
            }
        }
    }

    @Override
    public void onNext(T t) {
        try {
            subscriber.onNext(t);
        } catch (Throwable throwable) {
            onError(throwable);
        }
    }

    static String getStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter(sw, false);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }
}
