package com.mm.c.cloud.lib.misc.ssl;

import com.mm.c.cloud.lib.logger.TimberUtils;
import com.mm.c.cloud.lib.misc.utils.MD5Utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

/**
 * Created by Larry on 2016/6/27.
 */
public class MD5Checksum {
    MessageDigest digest;

    public MD5Checksum() {
        try {
            this.digest = MessageDigest.getInstance("MD5");
        } catch (NoSuchAlgorithmException var2) {
            TimberUtils.e(var2, "MessageDigest");
        }

    }

    public void update(String str) {
        if(this.digest != null) {
            this.digest.update(str.getBytes(), 0, str.getBytes().length);
        }

    }

    public void update(byte[] bytes) {
        if(this.digest != null) {
            this.digest.update(bytes, 0, bytes.length);
        }

    }

    public String getChecksum() {
        return MD5Utils.byteToString(this.digest.digest());
    }
}
