package com.mm.c.cloud.lib.misc.utils;

import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.os.storage.StorageManager;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/**
 * Created by elegant on 16/4/3.
 */
public class LocalDiskUtil {
    private static final String SOTRAGE_ROOT_PATH = "/storage";
    private static String MFC_DIR_NAME = "mfc";
    public static final int FILE_TYPE_DIRECTORY = 0;
    public static final int FILE_TYPE_VIDEO = 1;
    public static final int FILE_TYPE_AUDIO = 2;
    public static final int FILE_TYPE_IMAGE = 3;
    public static final int FILE_TYPE_APK = 4;

    public static String formatFileSize(long size) {
        if (size < 1024) {
            return String.format("%d B", size);
        } else if (size < 1024 * 1024) {
            return String.format("%.1f KB", size / 1024.0f);
        } else if (size < 1024 * 1024 * 1024) {
            return String.format("%.1f MB", size / 1024.0f / 1024.0f);
        } else {
            return String.format("%.1f GB", size / 1024.0f / 1024.0f / 1024.0f);
        }
    }


    public static String getStorageLabel(StorageManager sm, String path) {
        try {
            String label = (String) ReflectionUtils.invokeMethod(sm, "getVolumeFSLabel", new Class[]{String.class}, new Object[]{path});
            return label;
        } catch (InvocationTargetException e) {
            return null;
        }
    }

    public static String fileModifiedDate(File file) {
        long time = file.lastModified();
        Date date = new Date(time);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:MM");
        return sdf.format(date);
    }

    public static File[] listMedia(File dir) {
        if (!dir.isDirectory()) return null;
        File files[] = dir.listFiles();
        if (files == null || files.length == 0) return new File[]{};
        ArrayList<File> result = new ArrayList<File>();
        for (File file : files) {
            if (file.isDirectory()) {
                if (file.getName().equals(MFC_DIR_NAME)) break;
                result.add(file);
            } else {
                if (isMusic(file.getName()) || isPhoto(file.getName()) || isVideo(file.getName()) || isApk(file.getName())) {
                    result.add(file);
                }
            }
        }
        return result.toArray(new File[]{});
    }

    public static boolean isVideo(String filename) {
        String name = filename.toLowerCase();
        for (String ext : videoExtensions) {
            if (name.endsWith(ext))
                return true;
        }
        return false;
    }

    public static boolean isMusic(String filename) {
        String name = filename.toLowerCase();
        for (String ext : audioExtensions) {
            if (name.endsWith(ext))
                return true;
        }
        return false;
    }

    public static boolean isPhoto(String filename) {
        String name = filename.toLowerCase();
        for (String ext : imageExtensions) {
            if (name.endsWith(ext))
                return true;
        }
        return false;
    }

    public static boolean isApk(String filename) {
        String name = filename.toLowerCase();
        for (String ext : apkExtensions) {
            if (name.endsWith(ext))
                return true;
        }
        return false;
    }

    public static Intent getFileIntent(String param) {
        Intent intent = new Intent(Intent.ACTION_VIEW);
        intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        intent.putExtra("oneshot", 0);
        intent.putExtra("configchange", 0);
        Uri uri = Uri.fromFile(new File(param));
        intent.setDataAndType(uri, "video/*");
        return intent;
    }

    public static String getMediaType(int mediaType) {
        String typeStr = "application/*";
        switch (mediaType) {
            case FILE_TYPE_VIDEO:
                typeStr = "video/*";
                break;
            case FILE_TYPE_AUDIO:
                typeStr = "audio/*";
                break;
            case FILE_TYPE_IMAGE:
                typeStr = "image/*";
                break;
            case FILE_TYPE_APK:
                typeStr = "application/vnd.android.package-archive";
                break;
        }
        return typeStr;
    }


    private static StorageInfo getLocalDisk() {
        String def_path = Environment.getExternalStorageDirectory().getPath();
        boolean def_path_removable = Environment.isExternalStorageRemovable();
        String def_path_state = Environment.getExternalStorageState();
        boolean def_path_readonly = def_path_state.equals(Environment.MEDIA_MOUNTED_READ_ONLY);
        return new StorageInfo(def_path, def_path_readonly, def_path_removable, -1);
    }

    /**
     * 获取USB接入的存储设备, 访问方式是: 挂载
     * @return
     */
    public static List<StorageInfo> getPathsOfUsbDisk() {
        final String DIR_MNT = "/mnt/media_rw/";
        final String DIR_STORAGE = "/storage/";
        final List<String> SKIPS = Arrays.asList("emulated", "self");
        List<StorageInfo> arr = new ArrayList<>();
        try {
            Process proc = Runtime.getRuntime().exec("df");
            BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                if ((line.trim().contains(DIR_MNT) || line.contains(DIR_STORAGE))) {
                    String[] strs = line.split(" ");
                    for (int i = 0; strs != null && i < strs.length; i++) {
                        if (strs[i].contains(DIR_MNT) || strs[i].contains(DIR_STORAGE)) {
                            boolean skipRef = false;
                            for (String key: SKIPS){
                                if (strs[i].contains(key)) {
                                    skipRef = true;
                                    break;
                                }
                            }
                            if (!skipRef)arr.add(new StorageInfo(strs[i].trim(), false, true, 0));
                        }
                    }
                }
            }
            proc.destroy();
        } catch (Exception e) {
        } finally {
            return arr;
        }
    }

//    // 通过storage manager的getVolumes获取
//    public static List<StorageInfo> getStorageList(Context context) {
//        List<StorageInfo> list = new ArrayList<>();
//        StorageManager sm = (StorageManager) context.getSystemService(Context.STORAGE_SERVICE);
//        list.add(getLocalDisk()); // internal storage
//        int removableCount = 1;
//        if (Build.VERSION.SDK_INT >= 23) {
//            try {
//                List<?> volumes = (List<?>) ReflectionUtils.invokeMethod(sm, "getVolumes", null, null);
//                for (Object vol : volumes) {
//                    if (vol != null && (boolean) ReflectionUtils.invokeMethod(vol, "isMountedReadable", null, null) && (int) ReflectionUtils.invokeMethod(vol, "getType", null, null) == 0) {
//                        File path = (File) ReflectionUtils.invokeMethod(vol, "getPath", null, null);
//                        list.add(new StorageInfo(path.getAbsolutePath(), false, true, removableCount++));
//                    }
//                }
//            } catch (Exception e) {
//                TimberUtils.e(e, "getStorageList error");
//            }
//        } else {
//            try {
//                List<?> volumes = Arrays.asList((Object[]) ReflectionUtils.invokeMethod(sm, "getVolumeList", null, null));
//                for (Object vol : volumes) {
//                    if (vol != null && Environment.MEDIA_MOUNTED.equals((String) ReflectionUtils.invokeMethod(vol, "getState", null, null)) && !(boolean) ReflectionUtils.invokeMethod(vol, "isPrimary", null, null) && (boolean) ReflectionUtils.invokeMethod(vol, "isRemovable", null, null)) {
//                        String path = (String) ReflectionUtils.invokeMethod(vol, "getPath", null, null);
//                        list.add(new StorageInfo(path, false, true, removableCount++));
//                    }
//                }
//            } catch (Exception e) {
//                TimberUtils.e(e, "getStorageList error");
//            }
//        }
//
//        if (list.size() > 1)
//            // exclude the sdcard
//            return list.subList(1, list.size());
//        else
//            return LocalDiskUtil.getExternalStorageDirectories();
//    }
//
//    public static List<StorageInfo> getExternalStorageDirectories() {
//        List<StorageInfo> dirs = new ArrayList<>();
//        try {
//            Runtime runtime = Runtime.getRuntime();
//            Process proc = runtime.exec("mount");
//            InputStream is = proc.getInputStream();
//            InputStreamReader isr = new InputStreamReader(is);
//            String line;
//            BufferedReader br = new BufferedReader(isr);
//            int removableCount = 1;
//            while ((line = br.readLine()) != null) {
//                if (line.contains("secure")) continue;
//                if (line.contains("asec")) continue;
//
//                if (line.contains("fat")) {
//                    String columns[] = line.split(" ");
//                    if (columns != null && columns.length > 1) {
//                        dirs.add(new StorageInfo(columns[1], false, true, removableCount++));
//                    }
//                } else if (line.contains("fuse")) {
//                    String columns[] = line.split(" ");
//                    if (columns != null && columns.length > 1) {
//                        dirs.add(new StorageInfo(columns[1], false, true, removableCount++));
//                    }
//                }
//            }
//        } catch (IOException e) {
//            TimberUtils.e(e, "get external storage failed.");
//        }
//        return dirs;
//    }

//    public static List<StorageInfo> getStorageList() {
//        List<StorageInfo> list = new ArrayList<>();
//        String def_path = Environment.getExternalStorageDirectory().getPath();
//        boolean def_path_removable = Environment.isExternalStorageRemovable();
//        String def_path_state = Environment.getExternalStorageState();
//        boolean def_path_available = def_path_state.equals(Environment.MEDIA_MOUNTED) || def_path_state.equals(Environment.MEDIA_MOUNTED_READ_ONLY);
//        boolean def_path_readonly = Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED_READ_ONLY);
//
//        HashSet<String> paths = new HashSet<>();
//        int cur_removable_number = 1;
//
//        if (def_path_available) {
//            paths.add(def_path);
//            list.add(0, new StorageInfo(def_path, def_path_readonly, def_path_removable, def_path_removable ? cur_removable_number++ : -1));
//        }
//
//        BufferedReader buf_reader = null;
//        try {
//            String pattern = "(?i).*(block|vold).*(vfat|ntfs|exfat|fat32|ext3|ext4|fuseblk).*(rw|ro).*";
//            buf_reader = new BufferedReader(new FileReader("/proc/mounts"));
//            String line;
//            Timber.d("start parse /proc/mounts");
//            while ((line = buf_reader.readLine()) != null) {
//                Timber.d(line);
//                if (!line.contains("asec") && line.matches(pattern)) {
//                    StringTokenizer tokens = new StringTokenizer(line, " ");
//                    String unused = tokens.nextToken(); //device
//                    String mount_point = tokens.nextToken(); //mount point
//                    if (paths.contains(mount_point)) {
//                        continue;
//                    }
//                    unused = tokens.nextToken(); //file system
//                    List<String> flags = Arrays.asList(tokens.nextToken().split(",")); //flags
//                    boolean readonly = flags.contains("ro");
//
//                    if (line.contains("/dev/block")) {
//                        if (!line.contains("/mnt/secure")
//                                && !line.contains("/mnt/asec")
//                                && !line.contains("/mnt/obb")
//                                && !line.contains("/dev/mapper")
//                                && !line.contains("tmpfs")
//                                && !TextUtils.equals("/system", mount_point)
//                                && !TextUtils.equals("/data", mount_point)
//                                && !TextUtils.equals("/cache", mount_point)
//                                && !TextUtils.equals("/tee", mount_point)
//                                && !mount_point.startsWith("/swap")) {
//                            paths.add(mount_point);
//                            list.add(new StorageInfo(mount_point, readonly, true, cur_removable_number++));
//                        }
//                    }
//                }
//            }
//
//        } catch (IOException ex) {
//            ex.printStackTrace();
//        } finally {
//            if (buf_reader != null) {
//                try {
//                    buf_reader.close();
//                } catch (IOException ignored) {
//                }
//            }
//        }
//        return list;
//    }

    public static final String[] videoExtensions = {".3gp",
            ".3g2",
            ".divx",
            ".h264",
            ".h265",
            ".avi",
            ".m2ts",
            ".mkv",
            ".mov",
            ".mp4",
            ".mpg",
            ".mpeg",
            ".rm",
            ".rmvb",
            ".wmv",
            ".ts",
            ".tp",
            ".dat",
            ".vob",
            ".flv",
            ".bit",
            ".vc1",
            ".m4v",
            ".f4v",
            ".asf",
            ".lst",
            ".mts",
            ".webm",
            ".mpe",
            ".pmp",
            ".mvc",
            /* "" */
    };
    //music
    private static final String[] audioExtensions = {".mp3",
            ".wma",
            ".m4a",
            ".aac",
            ".ape",
            ".mp2",
            ".ogg",
            ".flac",
            ".alac",
            ".wav",
            ".mid",
            ".xmf",
            ".mka",
            ".aiff",
            ".aifc",
            ".aif",
            ".pcm",
            ".adpcm"
    };
    //photo
    private static final String[] imageExtensions = {".jpg",
            ".jpeg",
            ".bmp",
            ".tif",
            ".tiff",
            ".png",
            ".gif",
            ".giff",
            ".jfi",
            ".jpe",
            ".jif",
            ".jfif",
            ".mpo",
            ".3dg",
            "3dp"
    };
    private static final String[] apkExtensions = {".apk"};
}
